package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * This is the concrete implementation of the SimpleEventFactory.  It
 * implements the ISimpleEventFactory interface.
 * 
 * The SimpleEventFactory is a singleton as prescribed by the 
 * Abstract Factory pattern (Gamma et.al.).  It contains simple
 * constructors to build CommonBaseEvent and related complex 
 * type objects.
 * 
 * @author jgerken
 * @version 1.0
 */
public class SimpleEventFactoryImpl implements ISimpleEventFactory {

	private static final SimpleEventFactoryImpl instance =
		new SimpleEventFactoryImpl();

	/**
	 * Constructor for SimpleEventFactoryImpl.
	 */
	private SimpleEventFactoryImpl() {
		super();
	}

	/**
	 * Method IAssociationEngine.
	 * 
	 * Create and return a concrete AssociationEngine object.  Objects
	 * of this type are encapsulated into CommonBaseEvent objects.
	 * 
	 * @return IAssociationEngine
	 */
	public IAssociationEngine createAssociationEngine() {
		return new AssociationEngineImpl();
	}

	/**
	 * Method createCommonBaseEvent.
	 * 
	 * Create and return a concrete CommonBaseEvent object.
	 * 
	 * @return ICommonBaseEvent
	 */
	public ICommonBaseEvent createCommonBaseEvent() {
		return new CommonBaseEventImpl();
	}

	/**
	 * Method createExtendedDataElement.
	 * 
	 * Create and return a concrete ExtendedDataElement object.  Objects
	 * of this type are encapsulated into CommonBaseEvent objects.
	 * 
	 * @return IExtendedDataElement
	 */
	public IExtendedDataElement createExtendedDataElement() {
		return new ExtendedDataElementImpl();
	}

	/**
	 * Method createAssociatedEvent.
	 * 
	 * Create and return a concrete AssociatedEvent object.  Objects
	 * of this type are encapsulated into CommonBaseEvent objects.
	 * 
	 * @return IAssociatedEvent
	 */
	public IAssociatedEvent createAssociatedEvent() {
		return new AssociatedEventImpl();
	}

	/**
	 * Method createContextDataElement.
	 * 
	 * Create and return a concrete ContextDataElement object.  Objects
	 * of this type are encapsulated into CommonBaseEvent objects.
	 * 
	 * @return IContextDataElement
	 */
	public IContextDataElement createContextDataElement() {
		return new ContextDataElementImpl();
	}

	/**
	 * Method createComponentIdentification.
	 * 
	 * Create and return a concrete ComponentIdentification object.  Objects
	 * of this type are encapsulated into CommonBaseEvent objects.
	 * 
	 * @return IComponentIdentification
	 */
	public IComponentIdentification createComponentIdentification() {
		return new ComponentIdentificationImpl();
	}

	/**
	 * Method createMsgDataElement.
	 * 
	 * Create and return a concrete MsgDataElement object.  Objects
	 * of this type are encapsulated into CommonBaseEvent objects.
	 * 
	 * @return IMsgDataElement
	 */
	public IMsgDataElement createMsgDataElement() {
		return new MsgDataElementImpl();
	}

	/**
	 * Method getInstance.
	 * 
	 * Accessor method to retrieve the instance of the singleton factory.
	 * @return SimpleEventFactoryImpl
	 */
	public static ISimpleEventFactory getInstance() {
		return instance;
	}
}
