/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.util;


/**
 * @author marcelop
 * @since 0.2.0
 */
public class IDGenerator
{
	private long uniqueIDTime = 0;
	private int uniqueIDCounter = 0;

	/**
	 * Generates a string that can be used as an unique identifier.
	 * 
	 * <p>IMPORTANT: The string is always formed by digits (0-9).
	 *  
	 * @return String
	 */
	public synchronized String generateID()
	{
		long currentTime = System.currentTimeMillis();
		if(currentTime == uniqueIDTime)
		{
			uniqueIDCounter++;
		}
		else
		{
			uniqueIDCounter = 0;
			uniqueIDTime = currentTime;
		}

		StringBuffer uniqueIDCounterString = new StringBuffer(String.valueOf(uniqueIDCounter));
		while (uniqueIDCounterString.length() < 4)
			uniqueIDCounterString.insert(0, (int)(10*Math.random()));
		uniqueIDCounterString.insert(0, String.valueOf(uniqueIDTime));
		uniqueIDCounterString.insert(0, String.valueOf(hashCode()));

		return (uniqueIDCounterString.toString());
	}
	
	/**
	 * Returns a new ID value.
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		return generateID();
	}
}
