/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.common;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupService;


/**
 * @author slavescu
 */
public class GenerateConstants {
	//~ Static fields/initializers -----------------------------------------------------------------

	private static Class[] classes =
		{ 
			ExecutionXMLLoadersFactory.class,
			XMLexecutionEventLoader.class,
			XMLtypedEventLoader.class,
			XMLmessageEventLoader.class,
			XMLverdictEventLoader.class,
			XMLinvocationEventLoader.class
		};
	private static Class[] lookUpServiceClasses =
		{
			//TraceLookupService.class
		};

	//~ Methods ------------------------------------------------------------------------------------

	public static void main(String[] args) {
		GenerateConstants generateConstants = new GenerateConstants();
		generateConstants.processClasses();
	}

	private void processClasses() {
		List list = new ArrayList();

		for (int i = 0; i < classes.length; i++) {
			addFieldsName(classes[i], list);
		}

		for (int i = 0; i < lookUpServiceClasses.length; i++) {
			addLookUpServiceName(lookUpServiceClasses[i], list);
		}


		Collections.sort(list,new Comparator(){
			/**
			 *
			 */

			public int compare(Object o1, Object o2) {
				return ((String[])o1)[0].compareTo(((String[])o2)[0]);
			}

		});

		//		System.out.println("// "+ theClass.getName() +" related constants");
		String prevName = "";
		PrintWriter out;
		try {
			out =
				new PrintWriter(
					new FileWriter("C:/Program Files/eclipse/workspace/org.eclipse.hyades.models.common/src/org/eclipse/hyades/loaders/common/ExecutionConstants.java"));
			out.println(
				"/**********************************************************************\n"
					+ " * Copyright (c) 2003 Hyades project.\n"
					+ " * All rights reserved.   This program and the accompanying materials\n"
					+ " * are made available under the terms of the Common Public License v0.5\n"
					+ " * which accompanies this distribution, and is available at\n"
					+ " * http://www.eclipse.org/legal/cpl-v05.html\n"
					+ " *\n"
					+ " * Contributors:\n"
					+ " * IBM - Initial API and implementation\n"
					+ " **********************************************************************/\n"
					+ "package org.eclipse.hyades.loaders.common;\n"
					+ "\n"
					+ "/**\n"
					+ " * @author amathur\n"
					+ " */\n"
					+ "public class ExecutionConstants {\n");

			for (Iterator iter = list.iterator(); iter.hasNext();) {
				String[] field = (String[]) iter.next();

//				if (!field[0].equals(prevName)) {
				
					out.println(
						"\tprotected static final int "
							+ field[0]
							+ "_int = "
							+ LoadersUtils.getHashCode(field[1])
							+ ";");
//					prevName = field[0];
//				}
			}
			out.println("}\n");
			out.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	private void addLookUpServiceName(Class class1, List list) {
		try {
			LookupService lookupService = (LookupService)class1.newInstance();
			for (Iterator iter = lookupService.getSupportedTypes().iterator(); iter.hasNext();) {
				Class element = (Class) iter.next();
				String name = element.getName();
//				name = name.replace('.','_');
				if(name.lastIndexOf('.')>0)
					name = name.substring(name.lastIndexOf('.')+1); 
				list.add(new String[]{name,element.getName()});
			}
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
		
	}

	private void addFieldsName(Class theClass, List list) {

		try {
			Field[] fields = theClass.getDeclaredFields();
			for (int i = 0; i < fields.length; i++) {
				int mod = fields[i].getModifiers();
				if (Modifier.isProtected(mod) && Modifier.isStatic(mod) && Modifier.isFinal(mod) && fields[i].getType()==String.class)
				{
					Object value = fields[i].get(null);
					if(value!=null)
						list.add(new String[]{fields[i].getName(),value.toString()});
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
