/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.common;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.models.common.testprofile.TPFSeverity;
import org.eclipse.hyades.models.common.testprofile.impl.Common_TestprofileFactoryImpl;

/**
 * @author amathur
 *
 * This is the message event loader.
 */
public class XMLmessageEventLoader extends XMLexecutionEventLoader {
	
	protected final static String EVENT_MESSAGE_SEVERITY = "severity";
	protected TPFSeverity severity = null;

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String name) {
		super.initialize(context, name);
		severity = null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addAttribute(java.lang.String, java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		printAttribute(name, value);
		switch (LoadersUtils.getHashCode(name)) {
		case ExecutionConstants.EVENT_MESSAGE_SEVERITY_int :
			severity = TPFSeverity.get(Integer.parseInt(value));
			break;

		default:
			super.addAttribute(name, value);
			break;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addYourselfInContext()
	 */
	public void addYourselfInContext() {
		// Create the event
		TPFMessageEvent event = Common_TestprofileFactoryImpl.eINSTANCE.createTPFMessageEvent();
		
		// Now populate the specialized attributes
		event.setSeverity(severity);
		
		// populate the event with the base event attributes
		this.event = (TPFExecutionEvent) event;
		super.addYourselfInContext();
	}
}
