/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.configuration.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.configuration.CFGOperation;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent;
import org.eclipse.hyades.models.common.facades.behavioral.IPropertyGroup;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.impl.PropertyGroupImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>CFG Class</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl#getOperations <em>Operations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl#getArtifacts <em>Artifacts</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl#getInstances <em>Instances</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl#getInstantiations <em>Instantiations</em>}</li>
 * </ul>
 * </p>
 *
 * @extends IDeployableComponent
 * @generated NOT
 */
public abstract class CFGClassImpl extends CMNNamedElementImpl implements CFGClass, IDeployableComponent {
	/**
	 * The cached value of the '{@link #getOperations() <em>Operations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperations()
	 * @generated
	 * @ordered
	 */
	protected EList operations = null;

	/**
	 * The cached value of the '{@link #getArtifacts() <em>Artifacts</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getArtifacts()
	 * @generated
	 * @ordered
	 */
	protected EList artifacts = null;

	/**
	 * The cached value of the '{@link #getInstances() <em>Instances</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInstances()
	 * @generated
	 * @ordered
	 */
	protected EList instances = null;

	/**
	 * The cached value of the '{@link #getInstantiations() <em>Instantiations</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInstantiations()
	 * @generated
	 * @ordered
	 */
	protected EList instantiations = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CFGClassImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return Common_ConfigurationPackage.eINSTANCE.getCFGClass();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOperations() {
		if (operations == null) {
			operations = new EObjectContainmentWithInverseEList(CFGOperation.class, this, Common_ConfigurationPackage.CFG_CLASS__OPERATIONS, Common_ConfigurationPackage.CFG_OPERATION__OWNING_CLASS);
		}
		return operations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getArtifacts() {
		if (artifacts == null) {
			artifacts = new EObjectWithInverseResolvingEList.ManyInverse(CFGArtifact.class, this, Common_ConfigurationPackage.CFG_CLASS__ARTIFACTS, Common_ConfigurationPackage.CFG_ARTIFACT__DEPLOYABLE_INSTANCES);
		}
		return artifacts;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getInstances() {
		if (instances == null) {
			instances = new EObjectContainmentWithInverseEList(CFGInstance.class, this, Common_ConfigurationPackage.CFG_CLASS__INSTANCES, Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER);
		}
		return instances;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getInstantiations() {
		if (instantiations == null) {
			instantiations = new EObjectWithInverseResolvingEList(CFGInstance.class, this, Common_ConfigurationPackage.CFG_CLASS__INSTANTIATIONS, Common_ConfigurationPackage.CFG_INSTANCE__CLASS_TYPE);
		}
		return instantiations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_ConfigurationPackage.CFG_CLASS__OPERATIONS:
					return ((InternalEList)getOperations()).basicAdd(otherEnd, msgs);
				case Common_ConfigurationPackage.CFG_CLASS__ARTIFACTS:
					return ((InternalEList)getArtifacts()).basicAdd(otherEnd, msgs);
				case Common_ConfigurationPackage.CFG_CLASS__INSTANCES:
					return ((InternalEList)getInstances()).basicAdd(otherEnd, msgs);
				case Common_ConfigurationPackage.CFG_CLASS__INSTANTIATIONS:
					return ((InternalEList)getInstantiations()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_ConfigurationPackage.CFG_CLASS__OPERATIONS:
					return ((InternalEList)getOperations()).basicRemove(otherEnd, msgs);
				case Common_ConfigurationPackage.CFG_CLASS__ARTIFACTS:
					return ((InternalEList)getArtifacts()).basicRemove(otherEnd, msgs);
				case Common_ConfigurationPackage.CFG_CLASS__INSTANCES:
					return ((InternalEList)getInstances()).basicRemove(otherEnd, msgs);
				case Common_ConfigurationPackage.CFG_CLASS__INSTANTIATIONS:
					return ((InternalEList)getInstantiations()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_CLASS__ID:
				return getId();
			case Common_ConfigurationPackage.CFG_CLASS__NAME:
				return getName();
			case Common_ConfigurationPackage.CFG_CLASS__DESCRIPTION:
				return getDescription();
			case Common_ConfigurationPackage.CFG_CLASS__OPERATIONS:
				return getOperations();
			case Common_ConfigurationPackage.CFG_CLASS__ARTIFACTS:
				return getArtifacts();
			case Common_ConfigurationPackage.CFG_CLASS__INSTANCES:
				return getInstances();
			case Common_ConfigurationPackage.CFG_CLASS__INSTANTIATIONS:
				return getInstantiations();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_CLASS__ID:
				setId((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_CLASS__NAME:
				setName((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_CLASS__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_CLASS__OPERATIONS:
				getOperations().clear();
				getOperations().addAll((Collection)newValue);
				return;
			case Common_ConfigurationPackage.CFG_CLASS__ARTIFACTS:
				getArtifacts().clear();
				getArtifacts().addAll((Collection)newValue);
				return;
			case Common_ConfigurationPackage.CFG_CLASS__INSTANCES:
				getInstances().clear();
				getInstances().addAll((Collection)newValue);
				return;
			case Common_ConfigurationPackage.CFG_CLASS__INSTANTIATIONS:
				getInstantiations().clear();
				getInstantiations().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_CLASS__ID:
				setId(ID_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_CLASS__NAME:
				setName(NAME_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_CLASS__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_CLASS__OPERATIONS:
				getOperations().clear();
				return;
			case Common_ConfigurationPackage.CFG_CLASS__ARTIFACTS:
				getArtifacts().clear();
				return;
			case Common_ConfigurationPackage.CFG_CLASS__INSTANCES:
				getInstances().clear();
				return;
			case Common_ConfigurationPackage.CFG_CLASS__INSTANTIATIONS:
				getInstantiations().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_CLASS__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case Common_ConfigurationPackage.CFG_CLASS__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case Common_ConfigurationPackage.CFG_CLASS__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case Common_ConfigurationPackage.CFG_CLASS__OPERATIONS:
				return operations != null && !operations.isEmpty();
			case Common_ConfigurationPackage.CFG_CLASS__ARTIFACTS:
				return artifacts != null && !artifacts.isEmpty();
			case Common_ConfigurationPackage.CFG_CLASS__INSTANCES:
				return instances != null && !instances.isEmpty();
			case Common_ConfigurationPackage.CFG_CLASS__INSTANTIATIONS:
				return instantiations != null && !instantiations.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getLocation()
	 */
	public abstract String getLocation();

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getOwner()
	 */
	public abstract ITest getOwner();

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getResource()
	 */
	public abstract String getResource();

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#setLocation(java.lang.String)
	 */
	public abstract void setLocation(String location);
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#setResource(java.lang.String)
	 */
	public abstract void setResource(String resource);
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getMethods()
	 */
	public List getMethods() {
		return (List)getOperations();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getInstanceProperties()
	 */
	public IPropertyGroup getEnvironmentVariables() {
		PropertyGroupImpl propertyGroup = new PropertyGroupImpl();
		CFGInstanceImpl instance = (CFGInstanceImpl) getInstances().get(0);
		propertyGroup.setProperties(instance.getEnvironmentVariables());
		return propertyGroup;
	}

} //CFGClassImpl
