/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.fragments.BVRCombinedFragment;
import org.eclipse.hyades.models.common.fragments.BVRInteractionOperand;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRLifelineImpl;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl;

/**
 * @author jtoomey
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class HyadesBVRInteractionOperandAdapter extends AdapterImpl {

	/**
	 * 
	 */
	public HyadesBVRInteractionOperandAdapter() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#isAdapterForType(java.lang.Object)
	 */
	public boolean isAdapterForType(Object obj) {
		if (obj instanceof EObject)
		{
		  return ((EObject)obj).eClass() == Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteractionOperand();
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
	 */
	public void notifyChanged(Notification notification) {

		if(!(notification.getNotifier() instanceof EObject))
		{
			return;
		}
		EObject container = ((EObject)notification.getNotifier()).eContainer();
		if(container instanceof BVRCombinedFragment)
		{
			//container = ((BVRCombinedFragmentImpl)container).eContainer().eContainer().eContainer();
			container = EcoreUtil.getRootContainer(container);
		}
		if(!(container instanceof TPFTestSuite))
		{
			return;
		}
		if(!FacadeResourceFactoryImpl.PERSISTENCE_ID.equals(((TPFTestSuiteImpl)container).getPersistenceId()))
		{
			return;
		}
	
		int eventType = notification.getEventType();
		
		if ( eventType == Notification.ADD ||
			 eventType == Notification.ADD_MANY ||
			 eventType == Notification.REMOVE ||
			 eventType == Notification.REMOVE_MANY)
		{		
			switch (notification.getFeatureID(BVRInteractionOperand.class))
			{
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__INTERACTION_FRAGMENTS:
					BVRInteractionOperand operand = (BVRInteractionOperand) notification.getNotifier();
					BVRInteractionFragmentImpl action = null;
					TPFBehaviorImpl implementor = null;
					BVRLifelineImpl selfLifeline = null;
					List actions = null;
					Iterator iter = null;
					TPFTestSuiteImpl testSuite = null;
					
					switch(eventType)
					{
						case Notification.ADD:
							action = (BVRInteractionFragmentImpl)notification.getNewValue();							

//							implementor = (TPFBehaviorImpl)operand.getCombinedFragment().getInteraction().getBehavior();
//							selfLifeline = implementor.getSelfLifeline();
							// Add it to the front of the collection
//							action.getLifelines().add(0,selfLifeline); 

							HyadesUtil.INSTANCE.createSUTInstances((BVRInteractionImpl)operand.getInteraction(), action);

							if(action instanceof ITestInvocation)
							{
								ITestSuite test = HyadesUtil.INSTANCE.getTestSuite(((ITestInvocation)action).getInvokedTest());
								ITestSuite owner = (ITestSuite) EcoreUtil.getRootContainer(operand);
								 	
								if(owner != null && test != null && !owner.getId().equals(test.getId()))
								{
									if(!HyadesUtil.INSTANCE.containsSuite(owner.getIReferencedSuites(), test))
									{
										owner.getIReferencedSuites().add(test);
									}
								}
							}
							
							break;
						case Notification.ADD_MANY:
							actions = (List)notification.getNewValue();
							iter = actions.iterator();
							while (iter.hasNext()) {
								action = (BVRInteractionFragmentImpl)iter.next();

//								implementor = (TPFBehaviorImpl)operand.getCombinedFragment().getInteraction().getBehavior();
//								selfLifeline = implementor.getSelfLifeline();
								// Add it to the front of the collection
//								action.getLifelines().add(0,selfLifeline); 

								HyadesUtil.INSTANCE.createSUTInstances((BVRInteractionImpl)operand.getInteraction(), action);
								if(action instanceof ITestInvocation)
								{
									ITestSuite test = HyadesUtil.INSTANCE.getTestSuite(((ITestInvocation)action).getInvokedTest());
									ITestSuite owner = (ITestSuite) EcoreUtil.getRootContainer(operand);
								 	
									if(owner != null && test != null && !owner.getId().equals(test.getId()))
									{
										if(!HyadesUtil.INSTANCE.containsSuite(owner.getIReferencedSuites(), test))
										{
											owner.getIReferencedSuites().add(test);
										}
									}
								}								
							}
							break;				
						case Notification.REMOVE:
							action = (BVRInteractionFragmentImpl)notification.getOldValue();
							implementor = (TPFBehaviorImpl)operand.getCombinedFragment().getInteraction().getBehavior();
							selfLifeline = implementor.getSelfLifeline();
							if(selfLifeline != null)
								selfLifeline.getInteractionFragments().remove(action); 
							break;
						case Notification.REMOVE_MANY:
							actions = (List)notification.getOldValue();
							iter = actions.iterator();
							while (iter.hasNext()) {
								action = (BVRInteractionFragmentImpl)iter.next();
								implementor = (TPFBehaviorImpl)operand.getCombinedFragment().getInteraction().getBehavior();
								selfLifeline = implementor.getSelfLifeline();
								selfLifeline.getInteractionFragments().remove(action); 
							}
							break;
					}
				break;
			}
		}
	}

}
