/*
 * Created on May 15, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.eclipse.hyades.models.common.facades.behavioral.test;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.common.facades.behavioral.IAction;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.ICondition;
import org.eclipse.hyades.models.common.facades.behavioral.IDecision;
import org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.IMethod;
import org.eclipse.hyades.models.common.facades.behavioral.IProperty;
import org.eclipse.hyades.models.common.facades.behavioral.IStub;
import org.eclipse.hyades.models.common.facades.behavioral.ISystemUnderTest;
import org.eclipse.hyades.models.common.facades.behavioral.ITargetInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.IVerificationPoint;
import org.eclipse.hyades.models.common.facades.behavioral.impl.FacadeResourceFactoryImpl;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.models.common.testprofile.impl.Common_TestprofileFactoryImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl;

/**
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class ValidateFacadeImpl extends TestCase {

	Resource suite1Resource = null;
	String xmiFile = "TempEMFFile." + FacadeResourceFactoryImpl.TEST_SUITE_FILE_EXTENSION;

	Resource suite2Resource = null;
	String xmiFile2 = "TempEMFFile2." + FacadeResourceFactoryImpl.TEST_SUITE_FILE_EXTENSION;

	public ValidateFacadeImpl(String name)
	{
		super(name);
	}

	public static Test suite()
	{
		TestSuite junitTestSuite = new TestSuite("EMF Facade Impl Validation");
		
		junitTestSuite.addTest(new ValidateFacadeImpl("testTestSuiteCreation"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testTestSuiteModification"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testTestSUTRemoval"));	
		junitTestSuite.addTest(new ValidateFacadeImpl("testAddActions"));	
		junitTestSuite.addTest(new ValidateFacadeImpl("testRemoveActions"));	
		junitTestSuite.addTest(new ValidateFacadeImpl("testAddTargetInvocation"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testRemoveTargetInvocation"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testAddTestInvocation"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testRemoveTestInvocation"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testAddDecision"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testRemoveDecision"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testAddLoop"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testRemoveLoop"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testAddProperties"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testAddTestCases"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testRemoveTestCases"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testAddMethod"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testRemoveMethod"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testAddProperties"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testRemoveProperties"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testAddExternalImplementor"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testChangeImplementorType"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testGetObjectByID"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testGetTestSuiteFromObject"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testAddTestInvocationException"));
		junitTestSuite.addTest(new ValidateFacadeImpl("testAddMethodToTest"));
					
		return junitTestSuite;
	}
	
	public void setUp()
	{ 
		if(suite1Resource == null)
		{
			ResourceSet resourceSet = new ResourceSetImpl();
			File file = new File(xmiFile);
			URI fileURI = URI.createFileURI(file.getAbsolutePath());
			Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
			Map m = reg.getExtensionToFactoryMap();
			m.put(FacadeResourceFactoryImpl.TEST_SUITE_FILE_EXTENSION, new FacadeResourceFactoryImpl());		
			 
			resourceSet.getResourceFactoryRegistry();
			suite1Resource = resourceSet.createResource(fileURI);
		}
		if(suite2Resource == null)
		{
			ResourceSet resourceSet = new ResourceSetImpl();
			File file = new File(xmiFile2);
			URI fileURI = URI.createFileURI(file.getAbsolutePath());
			Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
			Map m = reg.getExtensionToFactoryMap();
			m.put(FacadeResourceFactoryImpl.TEST_SUITE_FILE_EXTENSION, new FacadeResourceFactoryImpl());		
			 
			resourceSet.getResourceFactoryRegistry();
			suite2Resource = resourceSet.createResource(fileURI);
		}
	}
		
	public void tearDown()
	{ 
	}
		
	public void testTestSuiteCreation()
	{
		ITestSuite testSuite = createTestSuite(suite1Resource);
		ITestCase testCase = createTestCase();
		testCase.setName("Test Case 1");
		testCase.setDescription("A simple test case");

		IImplementor implementor = createImplementor(testSuite, false);
		implementor.setName("Test Driver 1");
		implementor.setDescription("A test driver");
		implementor.setLocation("main");
		implementor.setResource("C:\\temp\\testDriver1.java");

		ISystemUnderTest systemUnderTest = createSystemUnderTest();
		systemUnderTest.setName("System Under Test 1");
		systemUnderTest.setDescription("A generic system under test");
		systemUnderTest.setLocation("");
		systemUnderTest.setResource("C:\\temp\\systemUnderTest1.java");

		IStub stub = createStub(testSuite);
		stub.setName("Stub 1");
		stub.setDescription("A sample stub");
		stub.setResource("c:\\temp\\stub1.java");
		stub.setLocation("");
		
		testSuite.setName("Test Suite 1");
		testSuite.setDescription("A simple Test Suite with one of everythiing");
		testSuite.getITestCases().add(0, testCase);
		testSuite.getISystemsUnderTest().add(0, systemUnderTest);
		testSuite.getIStubs().add(0, stub);
		
		// Check object		
		assertEquals("Test Suite 1", testSuite.getName());
		assertEquals("A simple Test Suite with one of everythiing", testSuite.getDescription());
		assertEquals(testCase, testSuite.getITestCases().get(0));
		assertEquals(stub, testSuite.getIStubs().get(0));
		assertEquals(systemUnderTest, testSuite.getISystemsUnderTest().get(0));		
		assertEquals(implementor, testSuite.getImplementor());

		// Save and reload into another object				
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();
		
		// Check reloaded object
		assertEquals("Test Suite 1", reloadedTestSuite.getName());
		assertEquals("A simple Test Suite with one of everythiing", reloadedTestSuite.getDescription());

		assertEquals("Test Case 1", ((ITestCase)reloadedTestSuite.getITestCases().get(0)).getName());
		assertEquals("A simple test case", ((ITestCase)reloadedTestSuite.getITestCases().get(0)).getDescription());
		assertEquals(reloadedTestSuite, ((ITestCase)reloadedTestSuite.getITestCases().get(0)).getOwner());

		assertEquals("Stub 1", ((IStub)reloadedTestSuite.getIStubs().get(0)).getName());
		assertEquals("A sample stub", ((IStub)reloadedTestSuite.getIStubs().get(0)).getDescription());
		assertEquals("c:\\temp\\stub1.java", ((IStub)reloadedTestSuite.getIStubs().get(0)).getResource());
		assertEquals("", ((IStub)reloadedTestSuite.getIStubs().get(0)).getLocation());
		assertEquals(reloadedTestSuite, ((IStub)reloadedTestSuite.getIStubs().get(0)).getOwner());

		assertEquals("System Under Test 1", ((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0)).getName());		
		assertEquals("A generic system under test", ((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0)).getDescription());		
		assertEquals("C:\\temp\\systemUnderTest1.java", ((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0)).getResource());		
		assertEquals("", ((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0)).getLocation());		
		assertEquals(reloadedTestSuite, ((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0)).getOwner());		
		
		assertEquals("Test Driver 1", ((IImplementor)reloadedTestSuite.getImplementor()).getName());
		assertEquals("A test driver", ((IImplementor)reloadedTestSuite.getImplementor()).getDescription());
		assertEquals("C:\\temp\\testDriver1.java", ((IImplementor)reloadedTestSuite.getImplementor()).getResource());
		assertEquals("main", ((IImplementor)reloadedTestSuite.getImplementor()).getLocation());
		assertEquals(reloadedTestSuite, ((IImplementor)reloadedTestSuite.getImplementor()).getOwner());

	}

	public void testTestSUTRemoval()
	{
		createSimpleTestSuite();
		ITestSuite testSuite = (ITestSuite)load();

		testSuite.getISystemsUnderTest().remove(0);
		// Check related object
		assertEquals(1, ((TPFBehaviorImpl)testSuite.getImplementor()).getInteraction().getLifelines().size());

		// Save and reload into another object						
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();
		
		// Check reloaded object
		assertEquals(0, reloadedTestSuite.getISystemsUnderTest().size());
	}
	
	public void testTestSuiteModification()
	{
		createSimpleTestSuite();
		ITestSuite testSuite = (ITestSuite)load();
		
		// Change some values
		testSuite.setName("Changed Test Suite");
		testSuite.setDescription("A changed Test Suite");
		
		// Add/remove some elements
		ISystemUnderTest systemUnderTest2 = createSystemUnderTest();
		ISystemUnderTest systemUnderTest3 = createSystemUnderTest();
		systemUnderTest2.setName("System Under Test 2");
		systemUnderTest2.setDescription("A generic system under test");
		systemUnderTest2.setLocation("");
		systemUnderTest2.setResource("C:\\temp\\systemUnderTest2.java");

		systemUnderTest3.setName("System Under Test 3");
		systemUnderTest3.setDescription("A generic system under test");
		systemUnderTest3.setLocation("");
		systemUnderTest3.setResource("C:\\temp\\systemUnderTest3.java");

		Vector someSUTs = new Vector();
		someSUTs.add(systemUnderTest2);
		someSUTs.add(systemUnderTest3);

		testSuite.getISystemsUnderTest().addAll(someSUTs);
		save(testSuite);
		
		IStub newStub = createStub(testSuite);
		newStub.setName("Stub 2");
		newStub.setDescription("A second stub");
		newStub.setLocation("");
		newStub.setResource("c:\\temp\\stub2.java");
		testSuite.getIStubs().add(newStub);
		
		// Check object
		assertEquals("Changed Test Suite", testSuite.getName());
		assertEquals("A changed Test Suite", testSuite.getDescription());
		assertEquals(3, testSuite.getISystemsUnderTest().size());
		assertEquals(systemUnderTest2, testSuite.getISystemsUnderTest().get(1));
		assertEquals(systemUnderTest3, testSuite.getISystemsUnderTest().get(2));
		assertEquals("System Under Test 2", ((ISystemUnderTest)testSuite.getISystemsUnderTest().get(1)).getName());
		assertEquals(newStub, testSuite.getIStubs().get(1));
			
		// Save and reload into another object		
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();
		
		// Check reloaded object
		assertEquals("Changed Test Suite", reloadedTestSuite.getName());
		assertEquals("A changed Test Suite", reloadedTestSuite.getDescription());

		assertEquals("System Under Test 2", ((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(1)).getName());		
		assertEquals("A generic system under test", ((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(1)).getDescription());		
		assertEquals("C:\\temp\\systemUnderTest2.java", ((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(1)).getResource());		
		assertEquals("", ((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(1)).getLocation());		
		assertEquals(reloadedTestSuite, ((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(1)).getOwner());		

		assertEquals("System Under Test 3", ((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(2)).getName());		
		assertEquals("A generic system under test", ((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(2)).getDescription());		
		assertEquals("C:\\temp\\systemUnderTest3.java", ((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(2)).getResource());		
		assertEquals("", ((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(2)).getLocation());		
		assertEquals(reloadedTestSuite, ((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(2)).getOwner());		

		assertEquals("Stub 2", ((IStub)reloadedTestSuite.getIStubs().get(1)).getName());
		assertEquals("A second stub", ((IStub)reloadedTestSuite.getIStubs().get(1)).getDescription());
		assertEquals("c:\\temp\\stub2.java", ((IStub)reloadedTestSuite.getIStubs().get(1)).getResource());
		assertEquals("", ((IStub)reloadedTestSuite.getIStubs().get(1)).getLocation());
		assertEquals(reloadedTestSuite, ((IStub)reloadedTestSuite.getIStubs().get(1)).getOwner());		
		
		Vector removedSUTs = new Vector();
		removedSUTs.add(reloadedTestSuite.getISystemsUnderTest().get(0));
		removedSUTs.add(reloadedTestSuite.getISystemsUnderTest().get(1));
		
		reloadedTestSuite.getISystemsUnderTest().removeAll(removedSUTs);
		
		assertEquals("System Under Test 3", ((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0)).getName());		
		assertEquals("A generic system under test", ((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0)).getDescription());		
		assertEquals("C:\\temp\\systemUnderTest3.java", ((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0)).getResource());		
		assertEquals("", ((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0)).getLocation());		
		assertEquals(reloadedTestSuite, ((ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0)).getOwner());		
		

		
	}
	
	public void testAddActions()
	{
		createSimpleTestSuite();
		ITestSuite testSuite = (ITestSuite)load();
		IImplementor implementor = (IImplementor)testSuite.getImplementor();
		IBlock block = implementor.getBlock();
		ISystemUnderTest systemUnderTest = (ISystemUnderTest)testSuite.getISystemsUnderTest().get(0);
		systemUnderTest.setDescription("An SUT with operations");
		systemUnderTest.setLocation("main");

		Vector actions = new Vector();

		// Create an operation
		IMethod method = createMethod();
		method.setName("method1");
		method.setDescription("Pick me!  Pick me!!");
		((IDeployableComponent)systemUnderTest).getMethods().add(method);
		
		// Create a target invocation
		ITargetInvocation targetInvocation = createTargetInvocation(method);
		targetInvocation.setName("Target Invocation 1");
		targetInvocation.setDescription("A simple target invocation");
		targetInvocation.setSynchronous(true);

		// Create a second test suite
		ITestSuite testSuite2 = createTestSuite(suite2Resource);
		IImplementor implementor2 = createImplementor(testSuite2, false);
		testSuite2.setName("Invokable Test Suite");
		testSuite2.setDescription("A TestSuite to be invoked");
		save(testSuite2);

		// Create a test invocation
		ITestInvocation testInvocation = createTestInvocation(testSuite2);
		testInvocation.setName("Test Invocation 1");
		testInvocation.setDescription("A simple test invocation");
		testInvocation.setSynchronous(true);

		// Create a VP
		IVerificationPoint actionVP = createVerificationPoint();
		actionVP.setName("VP 1");
		actionVP.setDescription("A generic VP");

		actions.add(targetInvocation);
		actions.add(testInvocation);
		actions.add(actionVP);
		
		block.getActions().addAll(actions);
		
		// Check object
		assertEquals(3, block.getActions().size());
		assertEquals(targetInvocation, block.getActions().get(0));
		assertEquals(testInvocation, block.getActions().get(1));
		assertEquals(actionVP, block.getActions().get(2));

		// Save and reload into another object						
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();

		// Check relaoded object
		IBlock tempBlock = reloadedTestSuite.getImplementor().getBlock(); 		
		assertEquals(3, tempBlock.getActions().size());
		assertEquals("Target Invocation 1", ((ITargetInvocation)tempBlock.getActions().get(0)).getName());
		assertEquals("method1", ((IMethod)((ITargetInvocation)tempBlock.getActions().get(0)).getInvocation()).getName());
		assertEquals(true, ((ITargetInvocation)tempBlock.getActions().get(0)).isSynchronous());			
		assertEquals("Test Invocation 1", ((ITestInvocation)tempBlock.getActions().get(1)).getName());
		assertEquals("A simple test invocation", ((ITestInvocation)tempBlock.getActions().get(1)).getDescription());
		assertEquals(true, ((ITestInvocation)tempBlock.getActions().get(1)).isSynchronous());
		assertEquals("Invokable Test Suite", ((ITestInvocation)tempBlock.getActions().get(1)).getInvokedTest().getName());				
		assertEquals("VP 1", ((IVerificationPoint)tempBlock.getActions().get(2)).getName());
		assertEquals("A generic VP", ((IVerificationPoint)tempBlock.getActions().get(2)).getDescription());
	}
	
	public void testRemoveActions()
	{
		testAddActions();
		ITestSuite testSuite = (ITestSuite)load();
		IImplementor implementor = (IImplementor)testSuite.getImplementor();
		IBlock block = implementor.getBlock();
		
		IAction action1 = (IAction)block.getActions().get(0);
		IAction action2 = (IAction)block.getActions().get(1);
		
		Vector actions = new Vector();

		actions.add(action1);
		actions.add(action2);
		
		// Check object
		block.getActions().removeAll(actions);
		assertEquals(1, block.getActions().size());
		assertTrue(block.getActions().get(0) instanceof IVerificationPoint);
		
		// Save and reload into another object						
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();

		// Check relaoded object
		IBlock tempBlock = reloadedTestSuite.getImplementor().getBlock(); 		
		assertEquals(1, tempBlock.getActions().size());
		assertEquals("VP 1", ((IVerificationPoint)tempBlock.getActions().get(0)).getName());
		assertEquals("A generic VP", ((IVerificationPoint)tempBlock.getActions().get(0)).getDescription());
	}
	
	public void testAddTargetInvocation()
	{
		createSimpleTestSuite();
		ITestSuite testSuite = (ITestSuite)load();
				
		IImplementor implementor = (IImplementor)testSuite.getImplementor();
		IBlock block = implementor.getBlock();
		ISystemUnderTest systemUnderTest = (ISystemUnderTest)testSuite.getISystemsUnderTest().get(0);
		systemUnderTest.setDescription("An SUT with operations");
		systemUnderTest.setLocation("main");
		
		// Create an operation
		IMethod method = createMethod();
		method.setName("method1");
		method.setDescription("Pick me!  Pick me!!");
		((IDeployableComponent)systemUnderTest).getMethods().add(method);
		
		// Create a target invocation
		ITargetInvocation targetInvocation = createTargetInvocation(method);
		targetInvocation.setName("Target Invocation 1");
		targetInvocation.setDescription("A simple target invocation");
		targetInvocation.setSynchronous(true);

		block.getActions().add(0, targetInvocation);
		
		// Check object
		assertEquals(targetInvocation, block.getActions().get(0));
		
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();

		// Check relaoded object		
		IImplementor tempImplementor = (IImplementor)reloadedTestSuite.getImplementor();
		IAction tempAction = (IAction)tempImplementor.getBlock().getActions().get(0);
		assertEquals("Target Invocation 1", tempAction.getName());
		assertEquals("method1", ((IMethod)((ITargetInvocation)tempAction).getInvocation()).getName());
		assertEquals(true, ((ITargetInvocation)tempAction).isSynchronous());			
	}
		
	public void testRemoveTargetInvocation()
	{
		testAddTargetInvocation();
		ITestSuite testSuite = (ITestSuite)load();
		IImplementor implementor = (IImplementor)testSuite.getImplementor();
		IBlock block = implementor.getBlock();
		
		block.getActions().remove(0);

		// Save and reload into another object				
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();
		
		// Check reloaded object
		IImplementor tempImplementor = (IImplementor)reloadedTestSuite.getImplementor();
		assertEquals(0, tempImplementor.getBlock().getActions().size());				
	}
	
	public void testAddTestInvocation()
	{
		createSimpleTestSuite();
		ITestSuite testSuite = (ITestSuite)load();
		IImplementor implementor = (IImplementor)testSuite.getImplementor();
		IBlock block = implementor.getBlock();

		ITestSuite testSuite2 = createTestSuite(suite2Resource);
		IImplementor implementor2 = createImplementor(testSuite2, false);
		testSuite2.setName("Invokable Test Suite");
		testSuite2.setDescription("A TestSuite to be invoked");
		save(testSuite2);

		ITestInvocation testInvocation = createTestInvocation(testSuite2);
		testInvocation.setName("Test Invocation 1");
		testInvocation.setDescription("A simple test invocation");
		testInvocation.setSynchronous(true);

//		ITestInvocation testInvocation2 = createTestInvocation(testSuite2);
//		testInvocation2.setName("Test Invocation 2");
//		testInvocation2.setDescription("A simple test invocation");
//		testInvocation2.setSynchronous(true);
		
		block.getActions().add(0, testInvocation);
//		block.getActions().add(1, testInvocation2);

		// Check object
		assertEquals(testInvocation, (ITestInvocation)testSuite.getImplementor().getBlock().getActions().get(0));
		
		// Save and reload into another object				
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();

		// Check relaoded object		
		IImplementor tempImplementor = (IImplementor)reloadedTestSuite.getImplementor();
		IAction tempAction = (IAction)tempImplementor.getBlock().getActions().get(0);
		assertEquals("Test Invocation 1", tempAction.getName());
		assertEquals("A simple test invocation", tempAction.getDescription());
		assertEquals(true, ((ITestInvocation)tempAction).isSynchronous());
		assertEquals("Invokable Test Suite", ((ITestInvocation)tempAction).getInvokedTest().getName());				
	}
	
	public void testRemoveTestInvocation()
	{
		testAddTestInvocation();
		ITestSuite testSuite = (ITestSuite)load();
		
		IImplementor implementor = (IImplementor)testSuite.getImplementor();
		IBlock block = implementor.getBlock();
		
		block.getActions().remove(0);

		// Check object
		assertEquals(0, block.getActions().size());

		// Save and reload into another object				
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();
		
		assertEquals(0, reloadedTestSuite.getImplementor().getBlock().getActions().size());
	}
	
	public void testAddDecision()
	{
		createSimpleTestSuite();
		ITestSuite testSuite = (ITestSuite)load();
		IImplementor implementor = (IImplementor)testSuite.getImplementor();
		IBlock block = implementor.getBlock();	

		Vector failureBlockActions = new Vector();

		// Create another test suite to invoke.
		ITestSuite testSuite2 = createTestSuite(suite2Resource);
		IImplementor implementor2 = createImplementor(testSuite2, false);
		testSuite2.setName("Invokable Test Suite");
		testSuite2.setDescription("A TestSuite to be invoked");
		save(testSuite2);

		// create some actions
		IVerificationPoint actionVP = createVerificationPoint();
		actionVP.setName("VP 1");
		actionVP.setDescription("A generic VP");

		ISystemUnderTest systemUnderTest = (ISystemUnderTest)testSuite.getISystemsUnderTest().get(0);
		IMethod method = createMethod();
		method.setName("method1");
		method.setDescription("Pick me!  Pick me!!");
		((IDeployableComponent)systemUnderTest).getMethods().add(method);

		ITargetInvocation actionTargetInvocation = createTargetInvocation(method);
		actionTargetInvocation.setName("Target Invocation 1");
		actionTargetInvocation.setDescription("A simple target invocation");

		ITestInvocation actionTestInvocation = createTestInvocation(testSuite2);
		actionTestInvocation.setName("Test Invocation 1");
		actionTestInvocation.setDescription("A simple test invocation");
		
		// create a decision
		
		IDecision decision = createDecision();
		block.getActions().add(decision);
		ICondition condition = decision.getCondition();
		condition.setConstraint("i>5");
		condition.setName("Condition 1");
		condition.setDescription("Less than 5");
		
		// Build the "then" clause
		decision.getSuccessBlock().getActions().add(actionTestInvocation);
		decision.getSuccessBlock().getActions().add(actionVP);

		// Build the "else" clause 
		IDecision nestedDecision = createDecision();
		nestedDecision.setName("Nested Decision");

		failureBlockActions.add(actionTargetInvocation);
		failureBlockActions.add(nestedDecision);

		decision.getFailureBlock().getActions().addAll(failureBlockActions);

		// Check object
		IImplementor tempImplementor = 	(IImplementor)testSuite.getImplementor();
		IAction tempAction = (IAction)tempImplementor.getBlock().getActions().get(0);
		assertEquals(decision, tempAction);
		assertEquals("i>5", ((IDecision)tempAction).getCondition().getConstraint());
		assertEquals(2, ((IDecision)tempAction).getSuccessBlock().getActions().size());
		assertEquals(2, ((IDecision)tempAction).getFailureBlock().getActions().size());
		assertEquals(testSuite2, ((ITestInvocation)((IDecision)tempAction).getSuccessBlock().getActions().get(0)).getInvokedTest());
		assertEquals(actionTestInvocation, ((IDecision)tempAction).getSuccessBlock().getActions().get(0));
		assertEquals(actionVP, ((IDecision)tempAction).getSuccessBlock().getActions().get(1));
		assertEquals(actionTargetInvocation, ((IDecision)tempAction).getFailureBlock().getActions().get(0));
		assertEquals(nestedDecision, ((IDecision)tempAction).getFailureBlock().getActions().get(1));
		
		// Save and reload into another object		
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();

		// Check object
		
		tempImplementor = (IImplementor)reloadedTestSuite.getImplementor();
		tempAction = (IAction)tempImplementor.getBlock().getActions().get(0);
		IDecision tempDecision = (IDecision)tempAction;
		assertEquals("i>5", tempDecision.getCondition().getConstraint());
		assertEquals(2, tempDecision.getSuccessBlock().getActions().size());
		assertEquals(2, tempDecision.getFailureBlock().getActions().size());
		assertEquals("Test Invocation 1", ((ITestInvocation)tempDecision.getSuccessBlock().getActions().get(0)).getName());
		assertEquals("A simple test invocation", ((ITestInvocation)tempDecision.getSuccessBlock().getActions().get(0)).getDescription());
		assertEquals(testSuite2.getName(), ((ITestInvocation)tempDecision.getSuccessBlock().getActions().get(0)).getInvokedTest().getName());
		assertEquals("VP 1", ((IVerificationPoint)tempDecision.getSuccessBlock().getActions().get(1)).getName());
		assertEquals("A generic VP", ((IVerificationPoint)tempDecision.getSuccessBlock().getActions().get(1)).getDescription());		
		assertEquals("Target Invocation 1", ((ITargetInvocation)tempDecision.getFailureBlock().getActions().get(0)).getName());
		assertEquals("A simple target invocation", ((ITargetInvocation)tempDecision.getFailureBlock().getActions().get(0)).getDescription());
		assertEquals("Nested Decision", ((IDecision)tempDecision.getFailureBlock().getActions().get(1)).getName());
	}

	public void testRemoveDecision()
	{
		testAddDecision();
		ITestSuite testSuite = (ITestSuite)load();
		IImplementor implementor = (IImplementor)testSuite.getImplementor();
		IBlock block = implementor.getBlock();	
		
		IDecision decision = (IDecision)block.getActions().get(0);
		decision.getFailureBlock().getActions().remove(1);
		
		assertEquals(1, decision.getFailureBlock().getActions().size());
		assertTrue(!(decision.getFailureBlock().getActions().get(0) instanceof IDecision));

		Vector removedActions = new Vector();
		removedActions.add(decision.getSuccessBlock().getActions().get(0));
		
		decision.getSuccessBlock().getActions().removeAll(removedActions);
		
		assertEquals(1, decision.getSuccessBlock().getActions().size());
		assertTrue(decision.getSuccessBlock().getActions().get(0) instanceof IVerificationPoint);


		block.getActions().remove(0);
		
		assertEquals(0, block.getActions().size());
		
		// Save and reload into another object		
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();

		assertEquals(0, reloadedTestSuite.getImplementor().getBlock().getActions().size());	
	}
	
	public void testAddLoop()
	{
		createSimpleTestSuite();
		ITestSuite testSuite = (ITestSuite)load();
		IImplementor implementor = (IImplementor)testSuite.getImplementor();
		IBlock block = implementor.getBlock();	

		Vector someLoopActions = new Vector();

		// Create another test suite to invoke.
		ITestSuite testSuite2 = createTestSuite(suite2Resource);
		IImplementor implementor2 = createImplementor(testSuite2, false);
		testSuite2.setName("Invokable Test Suite");
		testSuite2.setDescription("A TestSuite to be invoked");
		save(testSuite2);

		// create some actions
		IVerificationPoint actionVP = createVerificationPoint();
		actionVP.setName("VP 1");
		actionVP.setDescription("A generic VP");

		ITestInvocation actionTestInvocation = createTestInvocation(testSuite2);
		actionTestInvocation.setName("Test Invocation 1");
		actionTestInvocation.setDescription("A simple test invocation");
	
		ILoop loop = createLoop();
		block.getActions().add(loop);		
		someLoopActions.add(actionTestInvocation);
		someLoopActions.add(actionVP);
		loop.getBlock().getActions().addAll(someLoopActions);		
		loop.getCondition().setConstraint("int i = 0; i < 5; i++");	
		
		ILoop nestedLoop = createLoop();
		nestedLoop.setName("Nested Loop");
		nestedLoop.getCondition().setConstraint("true");
		loop.getBlock().getActions().add(nestedLoop);
		
		// Check object
		IImplementor tempImplementor = 	(IImplementor)testSuite.getImplementor();
		IAction tempAction = (IAction)tempImplementor.getBlock().getActions().get(0);
		assertEquals(loop, tempAction);
		assertEquals("int i = 0; i < 5; i++", ((ILoop)tempAction).getCondition().getConstraint());
		assertEquals(3, ((ILoop)tempAction).getBlock().getActions().size());
		assertEquals(testSuite2, ((ITestInvocation)((ILoop)tempAction).getBlock().getActions().get(0)).getInvokedTest());
		assertEquals(actionTestInvocation, ((ILoop)tempAction).getBlock().getActions().get(0));
		assertEquals(actionVP, ((ILoop)tempAction).getBlock().getActions().get(1));
		assertEquals(nestedLoop, ((ILoop)tempAction).getBlock().getActions().get(2));
		
		// Save and reload into another object		
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();

		// Check object
		tempImplementor = (IImplementor)reloadedTestSuite.getImplementor();
		tempAction = (IAction)tempImplementor.getBlock().getActions().get(0);
		ILoop tempLoop = (ILoop)tempAction;
		assertEquals("int i = 0; i < 5; i++", tempLoop.getCondition().getConstraint());
		assertEquals(3, tempLoop.getBlock().getActions().size());
		assertEquals("Test Invocation 1", ((ITestInvocation)tempLoop.getBlock().getActions().get(0)).getName());
		assertEquals("A simple test invocation", ((ITestInvocation)tempLoop.getBlock().getActions().get(0)).getDescription());
		assertEquals(testSuite2.getName(), ((ITestInvocation)tempLoop.getBlock().getActions().get(0)).getInvokedTest().getName());
		assertEquals("VP 1", ((IVerificationPoint)tempLoop.getBlock().getActions().get(1)).getName());
		assertEquals("A generic VP", ((IVerificationPoint)tempLoop.getBlock().getActions().get(1)).getDescription());			
		assertEquals("Nested Loop", ((ILoop)tempLoop.getBlock().getActions().get(2)).getName());
	}

	public void testRemoveLoop()
	{
		testAddLoop();
		ITestSuite testSuite = (ITestSuite)load();
		IImplementor implementor = (IImplementor)testSuite.getImplementor();
		IBlock block = implementor.getBlock();	

		ILoop loop = (ILoop)block.getActions().get(0);
		loop.getBlock().getActions().remove(2);
		
		assertEquals(2, loop.getBlock().getActions().size());
		assertTrue(!(loop.getBlock().getActions().get(0) instanceof ILoop));
		assertTrue(!(loop.getBlock().getActions().get(1) instanceof ILoop));
		
		Vector removedActions = new Vector();
		removedActions.add(loop.getBlock().getActions().get(0));
		removedActions.add(loop.getBlock().getActions().get(1));
		
		loop.getBlock().getActions().removeAll(removedActions);
		
		assertEquals(0, loop.getBlock().getActions().size());
		
		block.getActions().remove(0);
		assertEquals(0, block.getActions().size());

		// Save and reload into another object		
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();

		// Check object
		assertEquals(0, reloadedTestSuite.getImplementor().getBlock().getActions().size());
						
	}

	public void testAddProperties()
	{
		createSimpleTestSuite();
		ITestSuite testSuite = (ITestSuite)load();
		IImplementor implementor = (IImplementor)testSuite.getImplementor();
		IBlock block = implementor.getBlock();	

		// Createa an action
		IVerificationPoint actionVP = createVerificationPoint();
		actionVP.setName("VP 1");
		actionVP.setDescription("A generic VP");
	
		IProperty property1 = createProperty();
		property1.setName("prop1");
		property1.setDescription("The frist property");
		property1.setValue("foo");
		IProperty property2 = createProperty();
		property2.setName("Prop2");
		property2.setDescription("The second property");
		property2.setValue("bar");
		actionVP.getActionProperties().getProperties().add(0, property1);
		actionVP.getActionProperties().getProperties().add(1, property2);
		
		block.getActions().add(actionVP);

		// Check object		
		assertEquals(property1, (IProperty)((IAction)block.getActions().get(0)).getActionProperties().getPropertyByName("prop1"));
		assertEquals(property2, (IProperty)((IAction)block.getActions().get(0)).getActionProperties().getProperties().get(1));
		
		// Save and reload into another object		
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();

		// Check object
		IImplementor tempImplementor = (IImplementor)reloadedTestSuite.getImplementor();
		IAction tempAction = (IAction)tempImplementor.getBlock().getActions().get(0);
		assertEquals("foo" , tempAction.getActionProperties().getPropertyByName("prop1").getValue());				
		assertEquals("bar" , ((IProperty)tempAction.getActionProperties().getProperties().get(1)).getValue());				
	}

	public void testRemoveProperties()
	{
		testAddProperties();
		ITestSuite testSuite = (ITestSuite)load();
		IImplementor implementor = (IImplementor)testSuite.getImplementor();
		IBlock block = implementor.getBlock();	
		IAction action = (IAction)block.getActions().get(0);

		action.getActionProperties().getProperties().remove(0);

		// Check object
		assertEquals(1, action.getActionProperties().getProperties().size());
		assertEquals("bar", action.getActionProperties().getPropertyByName("Prop2").getValue());
	
		
		// Save and reload into another object		
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();

		// Check object
		IImplementor tempImplementor = (IImplementor)reloadedTestSuite.getImplementor();
		IAction tempAction = (IAction)tempImplementor.getBlock().getActions().get(0);
		assertEquals(1, tempAction.getActionProperties().getProperties().size());
		assertEquals("bar" , tempAction.getActionProperties().getPropertyByName("Prop2").getValue());				
		assertEquals("bar" , ((IProperty)tempAction.getActionProperties().getProperties().get(0)).getValue());				
	}

	public void testAddExternalImplementor()
	{
		createBlankTestSuite();
		ITestSuite testSuite = (ITestSuite)load();
		
		IImplementor externalImplementor = createImplementor(testSuite, true);
		externalImplementor.setName("An External Implementor");
		externalImplementor.setLocation("main");
		externalImplementor.setResource("ExternalImplementor.java");
	
		// Check object
		assertEquals(true, externalImplementor.isExternalImplementor());
		assertEquals(externalImplementor, testSuite.getImplementor());
		
		// Save and reload into another object		
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();

		// Check object
		assertNotNull(testSuite.getImplementor());
		IImplementor tempImplementor = reloadedTestSuite.getImplementor();
		assertEquals(true, tempImplementor.isExternalImplementor());
		assertEquals("main", tempImplementor.getLocation());
		assertNull(tempImplementor.getBlock());
	}
	
	public void testChangeImplementorType()
	{
		testAddExternalImplementor();
		ITestSuite testSuite = (ITestSuite)load();
		
		IImplementor modeledImplementor = createImplementor(testSuite, false);
		modeledImplementor.setName("An Modeled Implementor");
		modeledImplementor.setLocation("main");
		modeledImplementor.setResource("ModeledImplementor.java");

		// Check object
		assertEquals(false, modeledImplementor.isExternalImplementor());
		assertEquals(modeledImplementor, testSuite.getImplementor());
		
		// Save and reload into another object		
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();

		// Check object
		assertNotNull(testSuite.getImplementor());
		IImplementor tempImplementor = reloadedTestSuite.getImplementor();
		assertEquals(false, tempImplementor.isExternalImplementor());
		assertEquals("main", tempImplementor.getLocation());
		assertNotNull(tempImplementor.getBlock());
		assertEquals(0, tempImplementor.getBlock().getActions().size());		
	}
	
	public void testAddTestCases()
	{
		ITestSuite testSuite = createBlankTestSuite();
		
		// Add test cases
		ITestCase testCase1 = createTestCase();
		testCase1.setName("TestCase1");		
		testCase1.setDescription("A Test Case to test the get Method");

		ITestCase testCase2 = createTestCase();
		testCase2.setName("TestCase2");		
		testCase2.setDescription("A Test Case to test the put Method");

		ITestCase testCase3 = createTestCase();
		testCase3.setName("TestCase3");		
		testCase3.setDescription("A Test Case to test the get Method");

		ITestCase testCase4 = createTestCase();
		testCase4.setName("TestCase4");		
		testCase4.setDescription("A Test Case to test the put Method");
		
		Vector testCaseCollection = new Vector();
		testCaseCollection.add(testCase3);
		testCaseCollection.add(testCase4);
		
		// Add the test case to the test suite
		List testCases = testSuite.getITestCases();
		testCases.add(testCase1);
		testCases.add(testCase2);
		testCases.addAll(testCaseCollection);

		// Add an implementor for each test case
		IImplementor tc1Implementor = createImplementor(testCase1, false);		
		tc1Implementor.setName("TestCase1Implementor");
		tc1Implementor.setDescription("An Implementor for test case 1");
		tc1Implementor.setResource("TestCase1.java");
		tc1Implementor.setLocation("main");

		IImplementor tc2Implementor = createImplementor(testCase2, false);
		tc2Implementor.setName("TestCase2Implementor");
		tc2Implementor.setDescription("An Implementor for test case 2");
		tc2Implementor.setResource("TestCase2.java");
		tc2Implementor.setLocation("main");	

		// Add a SUT
		ISystemUnderTest systemUnderTest = createSystemUnderTest();
		systemUnderTest.setName("SUT1");
		systemUnderTest.setDescription("A system under test");
		systemUnderTest.setResource("SystemUnderTest1.java");
		systemUnderTest.setLocation("main");
		
		// Add the SUTs to the test suite
		List systemsUnderTest = testSuite.getISystemsUnderTest();
		systemsUnderTest.add(systemUnderTest);

		// Add invocations of test cases using loops and
		// conditions.		
		IBlock block1 = tc1Implementor.getBlock();
		List tc1Actions = block1.getActions();
		IBlock block2 = tc2Implementor.getBlock();
		List tc2Actions = block2.getActions();

		// Create operations
		IMethod method1 = createMethod();
		method1.setName("method1");
		method1.setDescription("The first method");
		((IDeployableComponent)systemUnderTest).getMethods().add(method1);

		IMethod method2 = createMethod();
		method2.setName("method2");
		method2.setDescription("The second method");
		((IDeployableComponent)systemUnderTest).getMethods().add(method2);

		// Create a target invocations
		ITargetInvocation method1TargetInvocation = createTargetInvocation(method1);
		method1TargetInvocation.setName("Invocation of method1");
		method1TargetInvocation.setDescription("A invocation of the first method");
		ITargetInvocation method2TargetInvocation = createTargetInvocation(method2);
		method2TargetInvocation.setName("Invocation of method2");
		method2TargetInvocation.setDescription("A invocation of the second method");

		// Add the target invocations
		tc1Actions.add(method1TargetInvocation);
		tc2Actions.add(method2TargetInvocation);

		// Check object		
		assertEquals(4, testSuite.getITestCases().size());
		assertEquals(1, testSuite.getISystemsUnderTest().size());
		assertEquals(testCase1, (ITestCase)testSuite.getITestCases().get(0));
		assertEquals(testCase2, (ITestCase)testSuite.getITestCases().get(1));
		assertEquals(testCase3, (ITestCase)testSuite.getITestCases().get(2));
		assertEquals(testCase4, (ITestCase)testSuite.getITestCases().get(3));
		assertEquals(systemUnderTest, (ISystemUnderTest)testSuite.getISystemsUnderTest().get(0));
		assertEquals(tc1Implementor, ((ITestCase)(testSuite.getITestCases().get(0))).getImplementor());
		assertEquals(tc2Implementor, ((ITestCase)(testSuite.getITestCases().get(1))).getImplementor());
		assertEquals(2, ((ISystemUnderTest)testSuite.getISystemsUnderTest().get(0)).getMethods().size());
		assertEquals(method1, (IMethod)((ISystemUnderTest)testSuite.getISystemsUnderTest().get(0)).getMethods().get(0));
		assertEquals(method2, (IMethod)((ISystemUnderTest)testSuite.getISystemsUnderTest().get(0)).getMethods().get(1));
		assertEquals(1, ((ITestCase)(testSuite.getITestCases().get(0))).getImplementor().getBlock().getActions().size());
		assertEquals(1, ((ITestCase)(testSuite.getITestCases().get(1))).getImplementor().getBlock().getActions().size());
		assertEquals(method1TargetInvocation, (ITargetInvocation)((ITestCase)(testSuite.getITestCases().get(0))).getImplementor().getBlock().getActions().get(0));
		assertEquals(method2TargetInvocation, (ITargetInvocation)((ITestCase)(testSuite.getITestCases().get(1))).getImplementor().getBlock().getActions().get(0));

		// Save and reload into another object		
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();

		// Check object
		assertEquals(4, reloadedTestSuite.getITestCases().size());
		assertEquals(1, reloadedTestSuite.getISystemsUnderTest().size());
		ITestCase tempTestCase1 = (ITestCase)testSuite.getITestCases().get(0);
		ITestCase tempTestCase2 = (ITestCase)testSuite.getITestCases().get(1);
		ITestCase tempTestCase3 = (ITestCase)testSuite.getITestCases().get(2);
		ITestCase tempTestCase4 = (ITestCase)testSuite.getITestCases().get(3);
		assertEquals("TestCase1", tempTestCase1.getName());
		assertEquals("TestCase2", tempTestCase2.getName());
		assertEquals("TestCase3", tempTestCase3.getName());
		assertEquals("TestCase4", tempTestCase4.getName());
		assertEquals("TestCase1Implementor", tempTestCase1.getImplementor().getName());
		assertEquals("TestCase2Implementor", tempTestCase2.getImplementor().getName());
		assertEquals(1, tempTestCase1.getImplementor().getBlock().getActions().size());
		assertEquals(1, tempTestCase2.getImplementor().getBlock().getActions().size());
		ITargetInvocation tempM1TargetInvocation = (ITargetInvocation)tempTestCase1.getImplementor().getBlock().getActions().get(0);
		ITargetInvocation tempM2TargetInvocation = (ITargetInvocation)tempTestCase2.getImplementor().getBlock().getActions().get(0);
		assertEquals("Invocation of method1", tempM1TargetInvocation.getName());
		assertEquals("Invocation of method2", tempM2TargetInvocation.getName());
		assertEquals("SUT1", tempM1TargetInvocation.getTarget().getName());
		assertEquals("SUT1", tempM2TargetInvocation.getTarget().getName());
		ISystemUnderTest tempSystemUnderTest = (ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0);
		assertEquals(2, tempSystemUnderTest.getMethods().size());
		assertEquals("method1", ((IMethod)tempSystemUnderTest.getMethods().get(0)).getName());
		assertEquals("method2", ((IMethod)tempSystemUnderTest.getMethods().get(1)).getName());
	}
	
	public void testRemoveTestCases()
	{
		testAddTestCases();
		ITestSuite testSuite = (ITestSuite)load();
				
		testSuite.getITestCases().remove(0);
				
		// Check object
		assertEquals(3, testSuite.getITestCases().size());
		assertEquals(1, testSuite.getISystemsUnderTest().size());
		ITestCase tempTestCase1 = (ITestCase)testSuite.getITestCases().get(0);
		assertEquals("TestCase2", tempTestCase1.getName());
		assertEquals("TestCase2Implementor", tempTestCase1.getImplementor().getName());
		assertEquals(1, tempTestCase1.getImplementor().getBlock().getActions().size());
		ITargetInvocation tempM1TargetInvocation = (ITargetInvocation)tempTestCase1.getImplementor().getBlock().getActions().get(0);
		assertEquals("Invocation of method2", tempM1TargetInvocation.getName());
		assertEquals("SUT1", tempM1TargetInvocation.getTarget().getName());
		ISystemUnderTest tempSystemUnderTest = (ISystemUnderTest)testSuite.getISystemsUnderTest().get(0);
		assertEquals(2, tempSystemUnderTest.getMethods().size());
		assertEquals("method1", ((IMethod)tempSystemUnderTest.getMethods().get(0)).getName());
		assertEquals("method2", ((IMethod)tempSystemUnderTest.getMethods().get(1)).getName());				

		// Multiple remove		
		Vector testCaseCollection = new Vector();
		testCaseCollection.add(testSuite.getITestCases().get(1));
		testCaseCollection.add(testSuite.getITestCases().get(2));
		testSuite.getITestCases().removeAll(testCaseCollection);
		
		// Check object
		assertEquals(1, testSuite.getITestCases().size());
		
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();

		assertEquals(1, reloadedTestSuite.getITestCases().size());
		assertEquals(1, reloadedTestSuite.getISystemsUnderTest().size());
		tempTestCase1 = (ITestCase)reloadedTestSuite.getITestCases().get(0);
		assertEquals("TestCase2", tempTestCase1.getName());
		assertEquals("TestCase2Implementor", tempTestCase1.getImplementor().getName());
		assertEquals(1, tempTestCase1.getImplementor().getBlock().getActions().size());
		tempM1TargetInvocation = (ITargetInvocation)tempTestCase1.getImplementor().getBlock().getActions().get(0);
		assertEquals("Invocation of method2", tempM1TargetInvocation.getName());
		assertEquals("SUT1", tempM1TargetInvocation.getTarget().getName());
		tempSystemUnderTest = (ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0);
		assertEquals(2, tempSystemUnderTest.getMethods().size());
		assertEquals("method1", ((IMethod)tempSystemUnderTest.getMethods().get(0)).getName());
		assertEquals("method2", ((IMethod)tempSystemUnderTest.getMethods().get(1)).getName());
	}

	public void testAddMethod()
	{
		createSimpleTestSuite();
		ITestSuite testSuite = (ITestSuite)load();
				
		IImplementor implementor = (IImplementor)testSuite.getImplementor();
		IBlock block = implementor.getBlock();
		ISystemUnderTest systemUnderTest = (ISystemUnderTest)testSuite.getISystemsUnderTest().get(0);
		systemUnderTest.setDescription("An SUT with operations");
		systemUnderTest.setLocation("main");
		
		// Create an operation
		IMethod method = createMethod();
		method.setName("method1");
		method.setDescription("Pick me!  Pick me!!");
		((IDeployableComponent)systemUnderTest).getMethods().add(method);
		
		// Check object
		assertEquals(method, (IMethod)systemUnderTest.getMethods().get(0));

		// Save and reload into another object		
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();
		
		assertEquals(1, reloadedTestSuite.getISystemsUnderTest().size());
		ISystemUnderTest tempSystemUnderTest = (ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0);
		assertEquals(1, tempSystemUnderTest.getMethods().size());
		IMethod tempMethod = (IMethod)tempSystemUnderTest.getMethods().get(0);
		assertEquals("method1", tempMethod.getName());
	}

	public void testRemoveMethod()
	{
		ITestSuite testSuite = createSimpleTestSuite();
		testAddMethod();
		testSuite = (ITestSuite)load();
				
		ISystemUnderTest systemUnderTest = (ISystemUnderTest)testSuite.getISystemsUnderTest().get(0);
		systemUnderTest.getMethods().remove(0);

		// Check object
		assertEquals(0, systemUnderTest.getMethods().size());

		// Save and reload into another object		
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();

		// Check reloaded object		
		assertEquals(1, reloadedTestSuite.getISystemsUnderTest().size());
		ISystemUnderTest tempSystemUnderTest = (ISystemUnderTest)reloadedTestSuite.getISystemsUnderTest().get(0);
		assertEquals(0, tempSystemUnderTest.getMethods().size());
	}
	
	public void testGetObjectByID()
	{
		createSimpleTestSuite();
		ITestSuite testSuite = (ITestSuite)load();
		
		ISystemUnderTest systemUnderTest = createSystemUnderTest();
		systemUnderTest.setName("System Under Test 2");
		systemUnderTest.setDescription("A generic system under test");
		systemUnderTest.setLocation("");
		systemUnderTest.setResource("C:\\temp\\systemUnderTest2.java");
		
		String sutID = systemUnderTest.getId();
		
		// Check object
		assertNull(HyadesFactory.INSTANCE.getObjectByID(testSuite, sutID));
		testSuite.getISystemsUnderTest().add(systemUnderTest);
		assertEquals(systemUnderTest, HyadesFactory.INSTANCE.getObjectByID(testSuite, sutID));
				
		// Save and reload into another object		
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();
		
		//	Check reloaded object	
		assertEquals("System Under Test 2", ((ISystemUnderTest)HyadesFactory.INSTANCE.getObjectByID(reloadedTestSuite, sutID)).getName());
		
		TPFTestSuiteImpl externalTestSuite = (TPFTestSuiteImpl)Common_TestprofileFactoryImpl.eINSTANCE.createTPFTestSuite();
		externalTestSuite.setName("External Test Suite");
		TPFBehaviorImpl externalBehavior = (TPFBehaviorImpl) Common_TestprofileFactoryImpl.eINSTANCE.createTPFBehavior();
		externalBehavior.setName(externalTestSuite.getName() + "_behavior");
		externalTestSuite.setBehavior(externalBehavior);
		String behaviorID = externalBehavior.getId();

		suite2Resource.getContents().add(externalTestSuite);
		save(externalTestSuite);
		
		testSuite.getIReferencedSuites().add(externalTestSuite);
		save(testSuite);
		reloadedTestSuite = (ITestSuite)load();

		//	Check reloaded object	
		assertEquals("System Under Test 2", ((ISystemUnderTest)HyadesFactory.INSTANCE.getObjectByID(reloadedTestSuite, sutID)).getName());
		assertEquals("External Test Suite_behavior", ((IImplementor)HyadesFactory.INSTANCE.getObjectByID(reloadedTestSuite, behaviorID)).getName());		
	}

	public void testGetTestSuiteFromObject()
	{
		createSimpleTestSuite();
		ITestSuite testSuite = (ITestSuite)load();
		
		Object object = testSuite.getITestCases().get(0);
		ITestSuite returnedTestSuite = HyadesFactory.INSTANCE.getTestSuiteFromObject(object);
		assertEquals(testSuite, returnedTestSuite);		
		
		object = new Object();
		try
		{
			returnedTestSuite = HyadesFactory.INSTANCE.getTestSuiteFromObject(object);
			assertTrue(false);
		}
		catch(Exception e)
		{
			assertTrue(e instanceof IllegalArgumentException);
		}
		
		object = createSystemUnderTest();
		returnedTestSuite = HyadesFactory.INSTANCE.getTestSuiteFromObject(object);
		assertEquals(null, returnedTestSuite);			
	}
	
	public void testAddTestInvocationException()
	{
		createSimpleTestSuite();
		ITestSuite testSuite = (ITestSuite)load();
		IImplementor implementor = (IImplementor)testSuite.getImplementor();
		IBlock block = implementor.getBlock();

		ITestSuite testSuite2 = createTestSuite(suite2Resource);
		testSuite2.setName("Invokable Test Suite");
		testSuite2.setDescription("A TestSuite to be invoked");
		save(testSuite2);

		ITestInvocation testInvocation = null;
		try
		{
			testInvocation = createTestInvocation(testSuite2);
			assertTrue(false);
		}
		catch(Exception e)
		{
			assertTrue(e instanceof IllegalArgumentException);
			assertEquals("Invoked test must have an implementor.", e.getMessage());			
		}
	}

	public void testAddMethodToTest()
	{
		createSimpleTestSuite();
		ITestSuite testSuite = (ITestSuite)load();
		IImplementor implementor = (IImplementor)testSuite.getImplementor();
		
		// Check that the empty state is correct
		assertNotNull(implementor.getMethods());
		assertEquals(0, implementor.getMethods().size());

		// Create a SUT		
		IBlock block = implementor.getBlock();
		ISystemUnderTest systemUnderTest = (ISystemUnderTest)testSuite.getISystemsUnderTest().get(0);
		systemUnderTest.setDescription("An SUT with operations");
		systemUnderTest.setLocation("main");
		
		// Create some operations
		IMethod method1 = createMethod();
		method1.setName("method1");
		method1.setDescription("Pick me!  Pick me!!");
		((IDeployableComponent)systemUnderTest).getMethods().add(method1);

		IMethod method2 = createMethod();
		method2.setName("method2");
		method2.setDescription("Pick me!  Pick me!!");
		
		// Create a target invocation
		ITargetInvocation targetInvocation = createTargetInvocation(method1);
		targetInvocation.setName("Target Invocation 1");
		targetInvocation.setDescription("A simple target invocation");
		targetInvocation.setSynchronous(true);

		block.getActions().add(0, targetInvocation);

		// Check that test operations don't affect the method list
		assertEquals(0, implementor.getMethods().size());		

		implementor.getMethods().add(method2);
		
		// Check that methods can be added
		assertEquals(1, implementor.getMethods().size());		
		assertEquals(method2, implementor.getMethods().get(0));
		
		// Save and reload into another object				
		save(testSuite);
		ITestSuite reloadedTestSuite = (ITestSuite)load();
		
		// Check reloaded object
		assertEquals(1, reloadedTestSuite.getImplementor().getMethods().size());
		assertEquals("method2", ((IMethod)reloadedTestSuite.getImplementor().getMethods().get(0)).getName());
	}

	private ITestSuite createBlankTestSuite()
	{
		ITestSuite testSuite = createTestSuite(suite1Resource);
		testSuite.setName("Test Suite 1");
		testSuite.setDescription("A simple Test Suite with one of everythiing");
		save(testSuite);		
		return testSuite;		
	}
	
	private ITestSuite createSimpleTestSuite()
	{
		ITestSuite testSuite = createTestSuite(suite1Resource);
		ITestCase testCase = createTestCase();
		testCase.setName("Test Case 1");
		testCase.setDescription("A simple test case");

		IImplementor implementor = createImplementor(testSuite, false);
		implementor.setName("Test Driver 1");
		implementor.setDescription("A test driver");
		implementor.setLocation("main");
		implementor.setResource("C:\\temp\\testDriver1.java");

		ISystemUnderTest systemUnderTest = createSystemUnderTest();
		systemUnderTest.setName("System Under Test 1");
		systemUnderTest.setDescription("A generic system under test");
		systemUnderTest.setLocation("");
		systemUnderTest.setResource("C:\\temp\\systemUnderTest1.java");

		IStub stub = createStub(testSuite);
		stub.setName("Stub 1");
		stub.setDescription("A sample stub");
		stub.setResource("c:\\temp\\stub1.java");
		stub.setLocation("");
		
		testSuite.setName("Test Suite 1");
		testSuite.setDescription("A simple Test Suite with one of everythiing");
		testSuite.getITestCases().add(0, testCase);
		testSuite.getISystemsUnderTest().add(0, systemUnderTest);
		testSuite.getIStubs().add(0, stub);		
		save(testSuite);		
		return testSuite;
	}
				
	private ITestSuite createTestSuite(Resource resource)
	{
		return HyadesFactory.INSTANCE.createTestSuite(resource);	
	}
	
	private ITestCase createTestCase()
	{
		return HyadesFactory.INSTANCE.createTestCase();
	}
	
	private IImplementor createImplementor(ITest implementedTest, boolean isExternalImplementor)
	{
		return HyadesFactory.INSTANCE.createImplementor(implementedTest, isExternalImplementor);	
	}

	private IStub createStub(ITest implementedTest)
	{
		return HyadesFactory.INSTANCE.createStub();	
	}
		
	private ISystemUnderTest createSystemUnderTest()
	{
		return HyadesFactory.INSTANCE.createSystemUnderTest();	
	}
	
	private IDecision createDecision()
	{
		return HyadesFactory.INSTANCE.createDecision();
	}

	private ILoop createLoop()
	{
		return HyadesFactory.INSTANCE.createLoop();	
	}
		
	private IVerificationPoint createVerificationPoint()
	{
		return HyadesFactory.INSTANCE.createVerificationPoint();
	}
		
	private ITargetInvocation createTargetInvocation(IMethod method)
	{
		return HyadesFactory.INSTANCE.createTargetInvocation(method);
	}

	private ITestInvocation createTestInvocation(ITest test)
	{
		return HyadesFactory.INSTANCE.createTestInvocation(test);
	}
	
	private IMethod createMethod()
	{
		return HyadesFactory.INSTANCE.createMethod();
	}
		
	private IProperty createProperty()
	{
		return HyadesFactory.INSTANCE.createProperty();
	}
			
	private void save(Object obj)
	{
		if(obj instanceof EObject)
		{	
			try 
			{
				((EObject)obj).eResource().save(Collections.EMPTY_MAP);
			} 
			catch (IOException e) 
			{
				e.printStackTrace();
			}
		}
	}
	
	private Object load()
	{
		ResourceSet resourceSet = new ResourceSetImpl();
		suite1Resource = resourceSet.getResource(URI.createURI(xmiFile), true);
		return suite1Resource.getContents().get(0);				
	}
}
