/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TPF Deployment</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFDeploymentImpl#getLocations <em>Locations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFDeploymentImpl#getDeploymentSpecs <em>Deployment Specs</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TPFDeploymentImpl extends CMNNamedElementImpl implements TPFDeployment
{
	/**
	 * The cached value of the '{@link #getLocations() <em>Locations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocations()
	 * @generated
	 * @ordered
	 */
	protected EList locations = null;

	/**
	 * The cached value of the '{@link #getDeploymentSpecs() <em>Deployment Specs</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeploymentSpecs()
	 * @generated
	 * @ordered
	 */
	protected EList deploymentSpecs = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TPFDeploymentImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return Common_TestprofilePackage.eINSTANCE.getTPFDeployment();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getLocations() {
		if (locations == null) {
			locations = new EObjectContainmentWithInverseEList(CFGLocation.class, this, Common_TestprofilePackage.TPF_DEPLOYMENT__LOCATIONS, Common_ConfigurationPackage.CFG_LOCATION__DEPLOYMENT);
		}
		return locations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getDeploymentSpecs() {
		if (deploymentSpecs == null) {
			deploymentSpecs = new EObjectContainmentWithInverseEList(CFGDeploymentSpec.class, this, Common_TestprofilePackage.TPF_DEPLOYMENT__DEPLOYMENT_SPECS, Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__DEPLOYMENT);
		}
		return deploymentSpecs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_TestprofilePackage.TPF_DEPLOYMENT__LOCATIONS:
					return ((InternalEList)getLocations()).basicAdd(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_DEPLOYMENT__DEPLOYMENT_SPECS:
					return ((InternalEList)getDeploymentSpecs()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_TestprofilePackage.TPF_DEPLOYMENT__LOCATIONS:
					return ((InternalEList)getLocations()).basicRemove(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_DEPLOYMENT__DEPLOYMENT_SPECS:
					return ((InternalEList)getDeploymentSpecs()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_DEPLOYMENT__ID:
				return getId();
			case Common_TestprofilePackage.TPF_DEPLOYMENT__NAME:
				return getName();
			case Common_TestprofilePackage.TPF_DEPLOYMENT__DESCRIPTION:
				return getDescription();
			case Common_TestprofilePackage.TPF_DEPLOYMENT__LOCATIONS:
				return getLocations();
			case Common_TestprofilePackage.TPF_DEPLOYMENT__DEPLOYMENT_SPECS:
				return getDeploymentSpecs();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_DEPLOYMENT__ID:
				setId((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_DEPLOYMENT__NAME:
				setName((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_DEPLOYMENT__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_DEPLOYMENT__LOCATIONS:
				getLocations().clear();
				getLocations().addAll((Collection)newValue);
				return;
			case Common_TestprofilePackage.TPF_DEPLOYMENT__DEPLOYMENT_SPECS:
				getDeploymentSpecs().clear();
				getDeploymentSpecs().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_DEPLOYMENT__ID:
				setId(ID_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_DEPLOYMENT__NAME:
				setName(NAME_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_DEPLOYMENT__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_DEPLOYMENT__LOCATIONS:
				getLocations().clear();
				return;
			case Common_TestprofilePackage.TPF_DEPLOYMENT__DEPLOYMENT_SPECS:
				getDeploymentSpecs().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_DEPLOYMENT__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case Common_TestprofilePackage.TPF_DEPLOYMENT__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case Common_TestprofilePackage.TPF_DEPLOYMENT__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case Common_TestprofilePackage.TPF_DEPLOYMENT__LOCATIONS:
				return locations != null && !locations.isEmpty();
			case Common_TestprofilePackage.TPF_DEPLOYMENT__DEPLOYMENT_SPECS:
				return deploymentSpecs != null && !deploymentSpecs.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

} //TPFDeploymentImpl
