/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;

/**
*Classification:  Abstract class representing a classification
*                  of data values into buckets.  Subclasses are specific
*                  classification strategies, which fall into two broad
*                  categories for classifying quantitative vs. categorical data.
*/
public abstract class Classification
{
	/*
	 * Values outside of any bucket
	 */
	public static final int NULL_BUCKET = -1;

	protected String _nullBucketLabel;

		public abstract void classify(ArrayList values);
		public abstract String label(int n);
		public abstract int numBuckets();
		public void setNullBucketLabel(String label) {
			_nullBucketLabel = label;
		}
}
