/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.views.internal.*;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class PrintColumnsDialog extends Dialog implements SelectionListener, Listener, ModifyListener {

	private Text _txtTargetFileName;
	private Button _btnTargetBrowse;
	private String _fileName = "";
	private String _title;
	private Shell _shell;

	public PrintColumnsDialog(Shell shell, String windowTitle, Image windowImage) {
		super(shell);
		_shell = shell;
		_title = windowTitle;
		setDefaultImage(windowImage);
	}
	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(_title);
	}
	protected Control createDialogArea(Composite parent) {
		Composite composite = (Composite) super.createDialogArea(parent);

		Composite targetGrp = new Composite(composite, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 3;
		layout.verticalSpacing = 10;
		layout.horizontalSpacing = 4;
		GridData data = GridUtil.createHorizontalFill();
		data.widthHint = 300;
		targetGrp.setLayout(layout);
		targetGrp.setLayoutData(data);

		Label locationLabel = new Label(targetGrp, SWT.NONE);
		data = new GridData();
		data.horizontalSpan = 3;
		locationLabel.setLayoutData(data);
		locationLabel.setText(TraceUIPlugin.getString("STR_PRINT_DLG_TEXT"));

		Label targetLabel = new Label(targetGrp, SWT.NONE);
		data = new GridData();
		targetLabel.setLayoutData(data);
		targetLabel.setText(TraceUIPlugin.getString("STR_PRINT_DLG_FILE"));

		_txtTargetFileName = new Text(targetGrp, SWT.BORDER);
		_txtTargetFileName.setLayoutData(GridUtil.createHorizontalFill());

		_btnTargetBrowse = new Button(targetGrp, SWT.PUSH);
		_btnTargetBrowse.setText(TraceUIPlugin.getString("STR_PRINT_DLG_BROWSE"));

		_btnTargetBrowse.addListener(SWT.Selection, this);
		_txtTargetFileName.addModifyListener(this);

		return composite;
	}
	protected void buttonPressed(int buttonId) {
		super.buttonPressed(buttonId);
	}
	protected void okPressed() {
		
		_fileName = _txtTargetFileName.getText().trim();
		if (_fileName == null || _fileName.equals("")) {
			org.eclipse.jface.dialogs.MessageDialog.openError(
				_shell,
				TraceUIPlugin.getString("STR_TRACE_MSG"),
				TraceUIPlugin.getString("STR_PRINT_DLG_ERROR"));
			return;
		}

		super.okPressed();
	}
	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	public void widgetSelected(SelectionEvent e) {
	}
	public void handleEvent(Event event) {
		if (event.widget == _btnTargetBrowse)
			showTargetDialog();
	}
	private void showTargetDialog() {
		String currentSource = _txtTargetFileName.getText();
		FileDialog dlg = new FileDialog(getShell(), SWT.SAVE);

		dlg.setFileName(currentSource);
		dlg.setFilterExtensions(new String[] { "*.htm", "*.*" });

		String target = dlg.open();

		if (target != null) {
			_txtTargetFileName.setText(target);
		}

		_fileName = target;
	}
	public void modifyText(ModifyEvent e) {
	}
	public String getFileName() {
		return _fileName;
	}
}