/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;


public class LookupServiceExtensions extends HashMap implements LookupService {
    //~ Static fields/initializers -----------------------------------------------------------------

    private static LookupServiceExtensions instance;

    //~ Instance fields ----------------------------------------------------------------------------

    private ArrayList alreadyProcessed;
    private Object result;

    //~ Constructors -------------------------------------------------------------------------------

    /**
     *
     */
    private LookupServiceExtensions() {
        super();
        alreadyProcessed = new ArrayList();
    }

    //~ Methods ------------------------------------------------------------------------------------

    /**
     *
     */
    public static LookupServiceExtensions getInstance() {
        if (instance == null) {
            instance = new LookupServiceExtensions();
            new LookupServiceRegistryReader().readRegistry();
        }

        return instance;
    }

    public Set getSupportedTypes() {
        return keySet();
    }

    public boolean deregister(HierarchyContext context, Class type, Object key) {
        LookupService lookupService = (LookupService) get(type);

        if (lookupService != null) {
            return lookupService.deregister(context, type, key);
        }

        return false;
    }

    public boolean deregister(HierarchyContext context, Object object) {
        LookupService lookupService = (LookupService) get(object.getClass());

        if (lookupService != null) {
            return lookupService.deregister(context, object);
        }

        return false;
    }

    public boolean deregister(HierarchyContext context, Class type) {
        LookupService lookupService = (LookupService) get(type);

        if (lookupService != null) {
            return lookupService.deregister(context, type);
        }

        return false;
    }

    public boolean deregister(HierarchyContext context) {
        boolean ret = false;
        List processed = new ArrayList();

        for (Iterator iter = entrySet().iterator(); iter.hasNext();) {
            Map.Entry entry = (Map.Entry) iter.next();
            LookupService lookupService = (LookupService) entry.getValue();

            if (!processed.contains(lookupService)) {
                if (!ret) {
                    ret = lookupService.deregister(context);
                } else {
                    lookupService.deregister(context);
                }

                processed.add(lookupService);
            }
        }

        return ret;
    }

    public Object locate(HierarchyContext context, Class type, Object key) {
        LookupService lookupService = (LookupService) get(type);

        if (lookupService != null) {
            return lookupService.locate(context, type, key);
        } else {
            return locate(context, key);
        }
    }

    public Object locate(HierarchyContext context, Object key) {
        alreadyProcessed.clear();

        for (Iterator iter = values().iterator(); iter.hasNext();) {
            LookupService element = (LookupService) iter.next();

            if (alreadyProcessed.contains(element)) {
                continue;
            }

            result = element.locate(context, key);

            if (result != null) {
                alreadyProcessed.clear();

                return result;
            }

            alreadyProcessed.add(element);
        }

        alreadyProcessed.clear();

        return null;
    }

    public boolean register(HierarchyContext context, Object object) {
		LookupService lookupService;
    	if(object.getClass()==GenericLookUpEntry.class)
			lookupService = (LookupService) get(((GenericLookUpEntry)object).value.getClass());
    	else
			lookupService = (LookupService) get(object.getClass());

        if (lookupService != null) {
            return lookupService.register(context, object);
        }

        return false;
    }
}
