/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.plugin;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Plugin;


public class HierarchyPlugin {
    //~ Static fields/initializers -----------------------------------------------------------------

    private static Implementation plugin;
    private static IWorkspaceRoot workspaceRoot;
    public static final String LOADER_PPID = "fragment_loader";
	public static final String HANDLER_PPID = "fragment_handler";
    public static final String LOADERS_FACTORY_PPID = "fragment_loaders_factory";
	public static final String RESOURCE_LOADER_PPID = "resource_loader";
    public static final String LOOKUP_SERVICE_PPID = "lookup_service";

    //~ Methods ------------------------------------------------------------------------------------

    public static Implementation getPlugin() {
        return plugin;
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return workspaceRoot;
    }

    public static void log(String string) {
        System.err.println(string);
    }

    //~ Inner Classes ------------------------------------------------------------------------------

    public static class Implementation extends Plugin {
        public Implementation(IPluginDescriptor descriptor) {
            super(descriptor);
            plugin = this;
        }

        public void startup() throws CoreException {
            super.startup();

            workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        }
    }
}
