/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;


public class EMFUtil {
    //~ Methods ------------------------------------------------------------------------------------


	public static Set delete(EObject object) {
		if (object == null || object.eResource()==null) {
			return Collections.EMPTY_SET;
		}

		return delete(object, object.eResource().getContents());
	}

	public static Set delete(final EObject object,Collection rootObjects) {
		if (object == null || object.eResource()==null) {
			return Collections.EMPTY_SET;
		}
		
		final Set changedResources = new HashSet();
		final boolean resolve = false;
		final ContainmentTraverser containmentTraverser = new ContainmentTraverser(rootObjects,resolve);

		EObjectVisitor objectVisitor = new EObjectVisitor() {
			public boolean beforeChildren(EObject element) {
				if(isContainedIn(element,object))
					return false;
				else
					return true;
			}

			public boolean afterChildren(EObject element) {
				boolean modified=false;
				for (Iterator iter1 = element.eClass().getEAllReferences().iterator();iter1.hasNext();)
				{
					EReference ref = (EReference) iter1.next();
					if(/*!ref.isContainment() && ref.isTransient() && */element.eIsSet(ref))
					{
						Object o = element.eGet(ref,resolve);
						if(o instanceof EObject)
						{
							if(isContainedIn((EObject)o,object))
							{
								element.eUnset(ref);
								modified=true;
							}
						}
						else if(o instanceof EList)
						{
							EList l = (EList)o;
							for (Iterator iter2 = containmentTraverser.getIterator(l);iter2.hasNext();)
							{
								Object entry = (Object) iter2.next();
								if(entry instanceof EObject)
								{								
									if(isContainedIn((EObject)o,object))
									{
										((InternalEList)l).basicRemove(entry,null);
										modified=true;
									}
								}
							}		
						}

					}
				}
				if(modified)
					changedResources.add(element.eResource());
				return true;
			}

		};

		containmentTraverser.registerVisitors(objectVisitor);

		containmentTraverser.traverse();
		
		return changedResources;
	}		

	public static Set delete(EObject object, ResourceSet resourceSet) {
		if (object == null || object.eResource()==null) {
			return Collections.EMPTY_SET;
		}
		if(resourceSet==null)
			return delete(object,object.eResource().getContents());

		return delete(object, getResourceSetRoots(resourceSet,null));
	}

	public static Set delete(Resource resource) {
		if (resource == null) {
			return Collections.EMPTY_SET;
		}

		return delete(resource, resource.getResourceSet());
	}

	public static Set delete(final Resource resource, ResourceSet resourceSet) {
		if ((resource == null) || (resourceSet == null)) {
			return Collections.EMPTY_SET;
		}
		final Set changedResources = new HashSet();
		final List resourceRoots = resource.getContents();
		final List resourceSetRoots = getResourceSetRoots(resourceSet,resource);
		final boolean resolve = false;
		final ContainmentTraverser containmentTraverser = new ContainmentTraverser(resourceSetRoots,resolve);

		EObjectVisitor objectVisitor = new EObjectVisitor() {
			public boolean beforeChildren(EObject element) {
				return true;
			}

			public boolean afterChildren(EObject element) {
				boolean modified=false;
				for (Iterator iter1 = element.eClass().getEAllReferences().iterator();iter1.hasNext();)
				{
					EReference ref = (EReference) iter1.next();
					if(/*!ref.isContainment() && ref.isTransient() && */element.eIsSet(ref))
					{
						Object o = element.eGet(ref,resolve);
						if(o instanceof EObject)
						{
							if(isContainedIn((EObject)o,resource))
							{
								element.eUnset(ref);
								modified=true;
							}
						}
						else if(o instanceof EList)
						{
							EList l = (EList)o;
							for (Iterator iter2 = containmentTraverser.getIterator(l);iter2.hasNext();)
							{
								Object entry = (Object) iter2.next();
								if(entry instanceof EObject)
								{								
									if(isContainedIn((EObject)entry,resource))
									{
										((InternalEList)l).basicRemove(entry,null);
										modified=true;
									}
								}
							}		
						}

					}
				}
				if(modified)
					changedResources.add(element.eResource());
				return true;
			}
		};

		containmentTraverser.registerVisitors(objectVisitor);

		containmentTraverser.traverse();
		
		resource.getContents().clear();
		
		resourceSet.getResources().remove(resource);
		
		return changedResources;
		
	}

	public static Set unload(final Resource resource, ResourceSet resourceSet) {
		if ((resource == null) || (resourceSet == null)) {
			return Collections.EMPTY_SET;
		}
		final Set changedResources = new HashSet();
		final List resourceRoots = resource.getContents();
		final List resourceSetRoots = getResourceSetRoots(resourceSet,resource);
		final boolean resolve = false;
		final ContainmentTraverser containmentTraverser = new ContainmentTraverser(resourceSetRoots,resolve);

		EObjectVisitor objectVisitor = new EObjectVisitor() {
			public boolean beforeChildren(EObject element) {
				return true;
			}

			public boolean afterChildren(EObject element) {
				boolean modified=false;
				for (Iterator iter1 = element.eClass().getEAllReferences().iterator();iter1.hasNext();)
				{
					EReference ref = (EReference) iter1.next();
					if(/*!ref.isContainment() && ref.isTransient() && */element.eIsSet(ref))
					{
						Object o = element.eGet(ref,resolve);
						if(o instanceof EObject  && !((EObject)o).eIsProxy())
						{
							if(isContainedIn((EObject)o,resource))
							{
								((InternalEObject) element).eSetProxyURI(EcoreUtil.getURI(element));
								modified=true;
							}
						}
						else if(o instanceof EList)
						{
							EList l = (EList)o;
							for (Iterator iter2 = containmentTraverser.getIterator(l);iter2.hasNext();)
							{
								Object entry = (Object) iter2.next();
								if(entry instanceof EObject && !((EObject)entry).eIsProxy())
								{								
									if(isContainedIn((EObject)entry,resource))
									{
										((InternalEObject) entry).eSetProxyURI(EcoreUtil.getURI((EObject)entry));
										modified=true;
									}
								}
							}		
						}

					}
				}
				if(modified)
					changedResources.add(element.eResource());
				return true;
			}
		};

		containmentTraverser.registerVisitors(objectVisitor);

		containmentTraverser.traverse();
		
		resource.getContents().clear();
		
		resourceSet.getResources().remove(resource);
		return changedResources;
		
	}

	public final static boolean isContainedIn(EObject object, Resource resource)
	{
		if(!object.eIsProxy())
			return resource == object.eResource();
		else
			//this should work for fragments but it won't work with ID's.
			return ((InternalEObject)object).eProxyURI().trimFragment().equals(resource.getURI());
			
	}
	public final static boolean isContainedIn(EObject object, EObject container)
	{
		if(!object.eIsProxy())
			return EcoreUtil.isAncestor(container,object);
		else
			//this should work for fragments but it won't work with ID's.
			return EcoreUtil.getURI(object).toString().indexOf(EcoreUtil.getURI(container).toString())>0;
			
	}

	public static List getResourceSetRoots(ResourceSet resourceSet,Resource ignoredResource)
	{
		List list = new BasicEList();
		for (Iterator iter1 = resourceSet.getResources().iterator(); iter1.hasNext();)
		{
			Resource resource = (Resource) iter1.next();
			if(resource!=ignoredResource)
				list.addAll(resource.getContents());
		}
		return list;
	}


	public static Set unload(Resource resource) {
		if (resource == null) {
			return Collections.EMPTY_SET;
		}
		return unload(resource,resource.getResourceSet());
	}
}
