/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.util;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent;
import org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary;
import org.eclipse.hyades.models.hierarchy.AbstractTRCDescription;
import org.eclipse.hyades.models.hierarchy.AbstractTRCProcess;
import org.eclipse.hyades.models.hierarchy.AbstractTRCView;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable;
import org.eclipse.hyades.models.hierarchy.TRCExecParameter;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;


/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage
 * @generated
 */
public class HierarchySwitch {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static HierarchyPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public HierarchySwitch() {
		if (modelPackage == null) {
			modelPackage = HierarchyPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public Object doSwitch(EObject theEObject) {
		EClass theEClass = theEObject.eClass();
		if (theEClass.eContainer() == modelPackage) {
			switch (theEClass.getClassifierID()) {
				case HierarchyPackage.TRC_PROCESS_PROXY: {
					TRCProcessProxy trcProcessProxy = (TRCProcessProxy)theEObject;
					Object result = caseTRCProcessProxy(trcProcessProxy);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case HierarchyPackage.TRC_OPTION: {
					TRCOption trcOption = (TRCOption)theEObject;
					Object result = caseTRCOption(trcOption);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case HierarchyPackage.TRC_AGENT: {
					TRCAgent trcAgent = (TRCAgent)theEObject;
					Object result = caseTRCAgent(trcAgent);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case HierarchyPackage.TRC_AGENT_PROXY: {
					TRCAgentProxy trcAgentProxy = (TRCAgentProxy)theEObject;
					Object result = caseTRCAgentProxy(trcAgentProxy);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case HierarchyPackage.TRC_CONFIGURATION: {
					TRCConfiguration trcConfiguration = (TRCConfiguration)theEObject;
					Object result = caseTRCConfiguration(trcConfiguration);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case HierarchyPackage.TRC_ENVIRONMENT_VARIABLE: {
					TRCEnvironmentVariable trcEnvironmentVariable = (TRCEnvironmentVariable)theEObject;
					Object result = caseTRCEnvironmentVariable(trcEnvironmentVariable);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case HierarchyPackage.TRC_EXEC_PARAMETER: {
					TRCExecParameter trcExecParameter = (TRCExecParameter)theEObject;
					Object result = caseTRCExecParameter(trcExecParameter);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case HierarchyPackage.TRC_FILTER: {
					TRCFilter trcFilter = (TRCFilter)theEObject;
					Object result = caseTRCFilter(trcFilter);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case HierarchyPackage.TRC_NODE: {
					TRCNode trcNode = (TRCNode)theEObject;
					Object result = caseTRCNode(trcNode);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case HierarchyPackage.TRC_MONITOR: {
					TRCMonitor trcMonitor = (TRCMonitor)theEObject;
					Object result = caseTRCMonitor(trcMonitor);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				default: return defaultCase(theEObject);
			}
		}
		return defaultCase(theEObject);
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Process Proxy</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Process Proxy</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCProcessProxy(TRCProcessProxy object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Option</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Option</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCOption(TRCOption object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Agent</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Agent</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCAgent(TRCAgent object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Agent Proxy</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Agent Proxy</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCAgentProxy(TRCAgentProxy object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Configuration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Configuration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCConfiguration(TRCConfiguration object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Environment Variable</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Environment Variable</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCEnvironmentVariable(TRCEnvironmentVariable object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Exec Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Exec Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCExecParameter(TRCExecParameter object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Filter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Filter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCFilter(TRCFilter object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Node</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Node</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCNode(TRCNode object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Monitor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Monitor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCMonitor(TRCMonitor object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Abstract Default Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Abstract Default Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseAbstractDefaultEvent(AbstractDefaultEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Abstract TRC View</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Abstract TRC View</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseAbstractTRCView(AbstractTRCView object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Abstract TRC Description</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Abstract TRC Description</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseAbstractTRCDescription(AbstractTRCDescription object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Abstract TRC Process</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Abstract TRC Process</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseAbstractTRCProcess(AbstractTRCProcess object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Abstract TRC Collection Boundary</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Abstract TRC Collection Boundary</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseAbstractTRCCollectionBoundary(AbstractTRCCollectionBoundary object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public Object defaultCase(EObject object) {
		return null;
	}

} //HierarchySwitch
