/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.test.util;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.eclipse.hyades.ui.internal.util.CoreUtil;

/**
 * Constains the methods to test the 
 * {@link org.eclipse.hyades.ui.internal.util.CoreUtil} class.
 *  
 * @author marcelop
 * @since 0.0.1
 */
public class CoreUtilTest 
extends TestCase
{
	/**
	 * Constructor for CoreUtilTest.
	 * @param name
	 */
	public CoreUtilTest(String name)
	{
		super(name);
	}

	/**
	 * Returns a suite with the tests defined in this class.
	 * @return Test
	 */
	public static Test suite()
	{
		TestSuite testSuite = new TestSuite("Hyades UI Core Util");
		testSuite.addTestSuite(CoreUtilTest.class);
		return testSuite;
	}
	
	/**
	 * Test for {@link CoreUtil#fromBynaryString(String)}
	 */
	public void testFromBynaryString()
	{
		assertEquals(5, CoreUtil.fromBynaryString("101"));
		assertEquals(5, CoreUtil.fromBynaryString("1a1"));
		
		assertEquals(10, CoreUtil.fromBynaryString("1010"));
		assertEquals(10, CoreUtil.fromBynaryString("a101b"));
	}

	/**
	 * Test for {@link CoreUtil#removeBitFlag(int, int)}
	 */
	public void testRemoveBitFlag()
	{
		int value =	CoreUtil.fromBynaryString("10100101");
		int flag  =	CoreUtil.fromBynaryString("00101000");
		assertEquals(CoreUtil.fromBynaryString("10000101"), CoreUtil.removeBitFlag(value, flag));
		
		flag  =	CoreUtil.fromBynaryString("10101001");
		assertEquals(CoreUtil.fromBynaryString("00000100"), CoreUtil.removeBitFlag(value, flag));	

		flag  =	CoreUtil.fromBynaryString("01011010");
		assertEquals(value, CoreUtil.removeBitFlag(value, flag));	
	}	
}
