/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.trace.internal.actions;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.emf.ecore.*;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.sd.trace.*;
import org.eclipse.hyades.sd.ui.*;
import org.eclipse.hyades.sd.ui.internal.model.*;
import org.eclipse.hyades.sd.ui.internal.views.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.jface.action.*;
import org.eclipse.jface.dialogs.*;
import org.eclipse.jface.resource.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;

public class OpenSDViewAction
	extends Action
	implements IWorkbenchWindowActionDelegate, IViewActionDelegate
{	 

	public OpenSDViewAction() {
		super("");

	}

	public OpenSDViewAction(String label) {
		super(label);
	}

	public OpenSDViewAction(String label, ImageDescriptor image) {
		super(label, image);
	}



	public void run() {
		IWorkbenchWindow window = SDPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();

		try {
			IWorkbenchPage persp = UIPlugin.getActivePage();
			SDViewer view = (SDViewer)persp.showView("org.eclipse.hyades.sd.ui.internal.views.SDViewer");
			
            int graphType=0;
			if (view != null){
				String menuItemName=getText();
				if(menuItemName.equals(SDTracePlugin.getString("STR_MENU_NOM")))
					graphType=Graph.NODEoverMETHOD;
				else if(menuItemName.equals(SDTracePlugin.getString("STR_MENU_OOM")))
					graphType=Graph.OBJECToverMETHOD;
				else if(menuItemName.equals(SDTracePlugin.getString("STR_MENU_COM")))
					graphType=Graph.CLASSoverMETHOD;
				else if(menuItemName.equals(SDTracePlugin.getString("STR_MENU_TOM")))
					graphType=Graph.THREADoverMETHOD;
				else if(menuItemName.equals(SDTracePlugin.getString("STR_MENU_POM")))
					graphType=Graph.PROCESSoverMETHOD;
				else if(menuItemName.equals(SDTracePlugin.getString("STR_MENU_AOM")))
					graphType=Graph.AGENToverMETHOD;
					
				view.addLoadViewPage((EObject)getMofObject(),graphType,false);
		   }
		} catch (Exception e) {
			String msg = SDTracePlugin.getString("STR_LOAD_SD_ERR_");

			Status err =
				new Status(
					Status.WARNING,
					ResourcesPlugin.PI_RESOURCES,
					IResourceStatus.INTERNAL_ERROR,
					e.toString(),
					null);

			ErrorDialog.openError(window.getShell(), msg, "",err);

			e.printStackTrace();
		}

	}

	public void dispose() {
		
	}
	
	public void init(IWorkbenchWindow window) {
	}

	private boolean collectExecutionInformation(TRCAgentProxy agentProxy)
	{

		if(agentProxy==null) return false;
	
		if(agentProxy.getType().equals(HyadesConstants.PROFILE_AGENT_TYPE))
		  return true;

		return false;
	}

	  
	//---- IWorkbenchWindowActionDelegate ------------------------------------------------

	public void run(IAction action) {
		run();
	}

	public void selectionChanged(IAction action, ISelection selection)
    {
	}
	
	public EObject getMofObject()
	{
		IWorkbenchPage page = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
		if(page == null || !page.getPerspective().getId().equals(PDPerspective.ID_TRACE_PERSPECTIVE) )
		  return null;
	  
		IViewPart monitorsView = page.findView(PDPerspective.ID_PD_NAVIGATOR_VIEW);
		if(monitorsView == null || !(monitorsView instanceof PDProjectExplorer))
		  return null;  
	  
		TreeItem item = null;  
		PDProjectViewer viewer = ((PDProjectExplorer)monitorsView).getViewer();
		if(viewer != null)
		   item = viewer.getTreeSelection();
	   
		if(item == null || !(item.getData() instanceof EObject))
		  return null;
	  
		return (EObject)item.getData();  
	}
	
	public void init(IViewPart view)
	{
	}
	
}

