/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.harness;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.*;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Plugin;

public class ExecutionHarnessPlugin extends Plugin
{
	private static ExecutionHarnessPlugin inst;
	private static ResourceBundle aResourceBundle;

	public ExecutionHarnessPlugin(IPluginDescriptor descriptor) {
		super(descriptor);

		//**** cash the Plugin and the resource bundle instances
		if (inst == null)
			inst = this;
		aResourceBundle = this.getDescriptor().getResourceBundle();
	}
	public static ExecutionHarnessPlugin getDefault() {
		return inst;
	}

	public static String getPluginId() {
		return getDefault().getDescriptor().getUniqueIdentifier();
	}

	public static ResourceBundle getResourceBundle() {
		return aResourceBundle;
	}
	
	public static String getString(String key) {
		ResourceBundle bundle = ExecutionHarnessPlugin.getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}
	
	/**
	 * 
	 * @param msg
	 */
	public void logError(Throwable exc)
	{
		Status status = new Status(1, getPluginId(), 0, exc.toString(), exc);
		getLog().log(status);
		
		exc.printStackTrace();
	}
	

}
