/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.jface.action.*;

/**
 * Action used to enable / disable method filter properties
 */
public class PDViewerFilterAction extends Action
{
	private int fFilterProperty;
	private PDProjectViewer fViewer;

	public PDViewerFilterAction(PDProjectViewer viewer,
		String label, int property, boolean initValue)
	{
		super(label);
		
		fViewer= viewer;
		fFilterProperty= property;
		setChecked(initValue);

		setToolTipText(label);
	}
	/**
	 * @see Action#actionPerformed
	 */
	public void run() {	
		valueChanged(isChecked());
	}
/* (non-Javadoc)
 * Method declared on IAction.
 */
public void setChecked(boolean checked)
{
	this.setChecked(checked, true);
}
/* (non-Javadoc)
 * Method declared on IAction.
 */
public void setChecked(boolean checked, boolean refresh)
{
	super.setChecked(checked);
	valueChanged(checked, refresh);
}
	private void valueChanged(boolean on)
	{
		valueChanged(on, false);
	}
	private void valueChanged(boolean on, boolean refresh) {
		if (on) {
			fViewer.removeFilter(fFilterProperty);
		} else {
			fViewer.addFilter(fFilterProperty);
		}

		if(refresh)
		{
			fViewer.refresh();			
		}
	}
}
