/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;

/*
* CONTEXT_ID rfrv0000 for refresh views action
*/
public class RefreshViewsActionDelegate extends AbstractListenerActionDelegate {
	
	/**
	 * @see AbstractProfileActionDelegate#doAction(Object)
	 */
	public void doAction(Object object) throws Exception {

		if (object == null || !(object instanceof EObject))
			return;

		PDProjectExplorer fViewer = UIPlugin.getDefault().getViewer();
		if (fViewer == null) {
			MessageDialog.openInformation(
				UIPlugin.getActiveWorkbenchShell(),
				"title",
				"Action not available in current context");
			return;
		}

		run((EObject)object, fViewer);
	}
		
		
	public void run(EObject object, PDProjectExplorer fViewer) {
		
		ProfileEvent event = UIPlugin.getDefault().getUpdateModelEvent(object);
		UIPlugin.getDefault().notifyProfileEventListener(event);           

	}
	
	/**
	 * @see AbstractProfileActionDelegate#isEnabledFor(Object)
	 */
	protected boolean isEnabledFor(Object element) {

		if (element != null
			&& (element instanceof EObject))
			return true;

		return false;

	}
	
}
