/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.console;

import org.eclipse.hyades.trace.ui.*;
import org.eclipse.jface.action.*;

/*
* CONTEXT_ID cloa0000 for clear output action
*/

/**
 * Clears the output of the selected launches
 */
public class ClearOutputAction extends Action {

	private final static String PREFIX= "clear_output_action.";
	private TraceConsoleViewer fConsoleViewer;

	public ClearOutputAction(TraceConsoleViewer viewer)
	{
		//super("Clear View");
		super(UIPlugin.getResourceString("STR_CLEAR_VIEW"));
		fConsoleViewer= viewer;
		//setToolTipText("Clear View");
		
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
		this,
		UIPlugin.getPluginId()+".cloa0000");
		
		setToolTipText(UIPlugin.getResourceString("CLEAROUTPUTACTION_TOOLTIP"));
	}
	/**
	 * @see Action
	 */
	public void run() {
		fConsoleViewer.clearDocument();
	}
}
