/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import java.util.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.jdt.core.*;

/**
 */
public class TraceManager extends PlatformObject
{
	/**
	 * Collection of launches
	 */
	protected ArrayList fTraces= new ArrayList(10);
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 3:29:57 PM)
 * @param trace com.ibm.etools.pd.core.launcher.TraceArguments
 */
public void deregisterTrace(TraceArguments trace)
{
	fTraces.remove(trace);	
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 6:18:05 PM)
 * @param agent com.ibm.etools.perftrace.TRCAgent
 */
public void deregisterTrace(TRCAgentProxy agent)
{
	TraceArguments trace = findTrace(agent);

	if(trace != null)
	  fTraces.remove(trace);
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 6:18:05 PM)
 * @param agent com.ibm.etools.perftrace.TRCProcessProxy
 */
public void deregisterTrace(TRCProcessProxy process)
{
	TraceArguments trace = findTrace(process);

	if(trace != null)
	  fTraces.remove(trace);
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 6:18:44 PM)
 * @return com.ibm.etools.pd.core.launcher.TraceArguments
 * @param agent com.ibm.etools.perftrace.TRCAgent
 */
public TraceArguments findTrace(TRCAgentProxy agent)
{
	Iterator list= fTraces.iterator();
	while (list.hasNext()) {
		TraceArguments l= (TraceArguments) list.next();
		if (agent == l.getAgent() || l.getProcess() != null && l.getProcess() == agent.getProcessProxy()) {
			return l;
		}
	}
	return null;	
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 6:18:44 PM)
 * @return com.ibm.etools.pd.core.launcher.TraceArguments
 * @param agent com.ibm.etools.perftrace.TRCProcessProxy
 */
public TraceArguments findTrace(TRCProcessProxy process)
{
	Iterator list= fTraces.iterator();
	while (list.hasNext()) {
		TraceArguments l= (TraceArguments) list.next();
		if (process == l.getProcess()) {
			return l;
		}
	}
	return null;	
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 4:17:25 PM)
 * @return com.ibm.etools.pd.core.launcher.TraceArguments
 * @param traceId java.lang.String
 */
public TraceArguments findTrace(String className)
{
	Iterator list= fTraces.iterator();
	while (list.hasNext()) {
		TraceArguments l= (TraceArguments) list.next();
		if (className.equals(l.toString())) {
			return l;
		}
	}
	return null;	
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 6:18:44 PM)
 * @return com.ibm.etools.pd.core.launcher.TraceArguments
 * @param IFile file
 */
public TraceArguments findTrace(IFile file)
{
	if(file == null)
	  return null;
	  
	Iterator list= fTraces.iterator();
	while (list.hasNext())
	{
		TraceArguments l= (TraceArguments) list.next();

		IType type = l.getType();
		if(type != null)
		{
		   IPath path = type.getJavaProject().getProject().getFullPath()
		   				.append(type.getFullyQualifiedName());
		   				
		   if(path.equals(file.getFullPath()))
				return l;
		}
	}
	return null;	
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 6:18:44 PM)
 * @return com.ibm.etools.pd.core.launcher.TraceArguments
 * @param IType type
 */
public TraceArguments findTrace(IType type)
{
	Iterator list= fTraces.iterator();
	while (list.hasNext()) {
		TraceArguments l= (TraceArguments) list.next();
		if (type == l.getType()) {
			return l;
		}
	}
	return null;	
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 4:17:25 PM)
 * @return com.ibm.etools.pd.core.launcher.TraceArguments
 * @param traceId java.lang.String
 */
public TraceArguments findTraceFromId(String traceId)
{
	Iterator list= fTraces.iterator();
	while (list.hasNext()) {
		TraceArguments l= (TraceArguments) list.next();
		if (traceId.equals(l.getId())) {
			return l;
		}
	}
	return null;	
}
	/**
	 */
	public ArrayList getTraces() {
		return fTraces;
	}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 4:29:28 PM)
 * @param agent com.ibm.etools.perftrace.TRCAgent
 * @param mode String
 */
public TraceArguments registerTrace(TRCAgentProxy agent, String mode)
{	
   String name = agent.getProcessProxy().getName();
	 
   TraceArguments trace = findTrace(name);
   if(trace != null)
   {	   
	   fTraces.remove(trace);

	   trace = new TraceArguments(agent, mode);
	   fTraces.add(0, trace);

	   return trace;
   }
	 
	trace = new TraceArguments(agent, mode);
	fTraces.add(0, trace);

	return trace;
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 4:29:28 PM)
 * @param agent com.ibm.etools.perftrace.TRCProcessProxy
 * @param mode String
 */
public TraceArguments registerTrace(TRCProcessProxy process, String mode)
{	
   TraceArguments trace = findTrace(process.getName());
   if(trace != null)
   {
	   fTraces.remove(trace);

	   trace = new TraceArguments(process, mode);	   
	   fTraces.add(0, trace);

	   return trace;
   }
	 
	trace = new TraceArguments(process, mode);
	fTraces.add(0, trace);

	return trace;
}
	/**
	 */
	public TraceArguments registerTrace(IType type)
	{
	   TraceArguments trace = findTrace(type.getFullyQualifiedName());
	   if(trace != null)
	   {
		   trace.setType(type);
		   
		   fTraces.remove(trace);
		   fTraces.add(0, trace);

		   return trace;
	   }

	    trace = new TraceArguments(type);
		fTraces.add(0, trace);

		return trace;
	}
}
