/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.*;

import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.jface.wizard.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.core.resources.*;
import org.eclipse.ui.*;

public class NewNodeWizard extends Wizard implements INewWizard
{
  protected NewNodeWizardPage fPage;
  protected TRCMonitor        fMonitor;
  protected PDProjectExplorer fViewer;

  public NewNodeWizard()
  {
	setNeedsProgressMonitor(true);
  }  
  public void addPages()
  {
	setWindowTitle(UIPlugin.getResourceString("NEW_NODE_TITLE"));
	fPage = new NewNodeWizardPage("NewNodePage", fMonitor, fViewer);
	addPage(fPage);
  }        
/**
 * Insert the method's description here.
 * Creation date: (10/05/2000 4:17:37 PM)
 * @return com.ibm.itp.core.api.resources.IResource
 */
public IResource getSelectionFolder()
{
	return fViewer.getSelectionFolder();
}
/**
 * Insert the method's description here.
 * Creation date: (8/7/2001 8:33:49 PM)
 * @return com.ibm.etools.pd.core.PDProjectExplorer
 */
public PDProjectExplorer getViewer() {
	return fViewer;
}
  public void init(IWorkbench workbench, IStructuredSelection selection)
  {
	if (selection instanceof IStructuredSelection)
	{
	  Iterator enum = ((IStructuredSelection) selection).iterator();
	  if (enum.hasNext())
	  {
		Object obj = enum.next();
		if (obj instanceof TRCMonitor)
		  fMonitor = (TRCMonitor) obj;
	  }
	}
	
	setDefaultPageImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_NEWNODE));
  }  
  public boolean performFinish()
  {
	if( fPage.finish() )
	{
	  fViewer.getViewer().refresh(fMonitor);		
	  fViewer.selectObject(fPage.getNode());		  
	 
	  return true;
	  		
	}

	return false;
  }  
  public void setViewer(PDProjectExplorer viewer)
  {
	fViewer = viewer;
  }  
}
