/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ConcurrentModificationException;
import java.util.Iterator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.*;
import org.eclipse.hyades.internal.execution.local.control.*;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.internal.core.*;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/*
* CONTEXT_ID opcp0000 for open profile options page
*/

public class OpenProfCollectionsPage  extends WizardPage 
{
	protected PDProjectExplorer fViewer;
	protected TraceProfileCollectionsUI _optionsUI;

  public OpenProfCollectionsPage(String name, PDProjectExplorer viewer)     

  {
	super(name);
	setTitle(UIPlugin.getResourceString("PROF_LIMIT_TITLE"));
	setDescription(UIPlugin.getResourceString("PROF_LIMIT_DESC"));
	fViewer = viewer;
	  
  }    /**
 * Insert the method's description here.
 * Creation date: (08/22/2000 4:48:53 PM)
 * @param show boolean
 */    
  public void createControl(Composite parent)
  {
	Label label;

	Composite content = new Composite(parent, SWT.NONE);
	GridLayout layout = new GridLayout();
	layout.numColumns = 1;
	layout.verticalSpacing=5;       
	content.setLayout(layout);
	GridData gd = GridUtil.createFill();
	content.setLayoutData(gd);

	_optionsUI = new TraceProfileCollectionsUI();
	_optionsUI.createControl(content);
	_optionsUI.setWizardPage(this);
	
	TRCAgentProxy agent = ((OpenProfAgentWizard)getWizard()).getAgent();

	setControl(content);
	populateData();

	if(agent == null || !agent.isActive())
	{
		setPageComplete(false);
		_optionsUI.enable(false);
	}

	   org.eclipse.ui.help.WorkbenchHelp.setHelp(
			  parent,
	   UIPlugin.getPluginId()+".opcp0000");
	
  }  
  
  
  
  /**
   * The following method will set the appropriate variables based on user's selected
   * options.  The configuration is send to the RAC only if 'shouldSend' is set.
   * 
   * @param		shouldSend - Configurations are send to the RAC only if this indicator is set
   * @return	True if the method succeeded; otherwise false.
   */
  public boolean finish(boolean shouldSend)
  {     
	TRCAgentProxy agent = ((OpenProfAgentWizard)getWizard()).getAgent();

	if(agent == null || !agent.isActive())
	  return true;

	try {
		Object[] configs = agent.getConfigurations().toArray();

		if(configs.length > 0)
		{
			setConfiguration((TRCConfiguration)configs[0]);
		}
		else
		{
			HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();         
			TRCConfiguration config = factory.createTRCConfiguration();
			config.setAgentProxy(agent);
			agent.getConfigurations().add(config);

			setConfiguration(config);
		}

		/* Send the configuration to the agent if the trace is active and monitored.
		 * The configuration is only send if 'shouldSend' is set. */
		if(shouldSend && agent.isActive() && agent.isMonitored())
		{
			TRCProcessProxy process = agent.getProcessProxy();
			TRCNode node = process.getNode();
			sendConfigurationToAgent(agent, node.getName(), process.getPid());			
			
		}
		
	}
	catch(ConcurrentModificationException exc)
	{
		exc.printStackTrace();
	}
		
	return true;    

  } 
  
  
  /**
   * Same as finish(true);
   * @see finish(boolean shouldSend)
   */
  public boolean finish()
  {
	return finish(true);
  }
  
  
  
/**
 * Insert the method's description here.
 * Creation date: (11/10/2000 12:50:32 PM)
 * @param agent com.ibm.etools.perftrace.TRCAgent
 */
private void sendConfigurationToAgent(TRCAgentProxy agent, String host, int processId)
{
	Node node = PDCoreUtil.profileConnect(host, String.valueOf(agent.getProcessProxy().getNode().getPort()));
	if(node == null)
		return;

	
	Process p = node.getProcess(String.valueOf(processId));

	if(p != null)
	{
		try {
			Agent a = p.getAgent(agent.getName());
			PDCoreUtil.setAgentConfiguration(agent, a);
			if(a != null && a.isActive()) {
			  a.publishConfiguration();
			  
			  /* Apply the filters */
			  CustomCommand command = new CustomCommand();
			  command.setData("APPLYFILTERS");
			  a.invokeCustomCommand(command);			  
			}			
		}
		catch(InactiveAgentException aex)
		{
		}
	}
}
   
/**
 * Insert the method's description here.
 * Creation date: (10/05/2000 3:17:53 PM)
 */
protected void populateData()
{
	TRCAgentProxy agent = ((OpenProfAgentWizard)getWizard()).getAgent();

	if(agent == null)
	  return;

	EList options = null;
	
	EList configs = agent.getConfigurations();
	Iterator i = configs.iterator();
	if (i.hasNext())
	{
		TRCConfiguration config = (TRCConfiguration)i.next();
		options = config.getOptions();

		updateConfigData(options);                         
		return;
	}

	updateConfigData(options);                     
}
/**
 * Insert the method's description here.
 * Creation date: (08/22/2000 5:45:29 PM)
 * @param config com.ibm.etools.perftrace.TRCConfiguration
 */
protected void setConfiguration(TRCConfiguration config)
{
	try {
	
		Object[] options = config.getOptions().toArray();
	
		//add the UI options    
		HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
	
		//time,imvocations limited events
		if (_optionsUI.getLimitInvocations()) {
			TRCOption opt = factory.createTRCOption();
			opt.setKey(Options.OPTION_BURST_MODE);
	
			if (_optionsUI.getLimitTime()) {
				opt.setValue(Options.OPTION_VALUE_SECONDSANDINVOCATIONS);
	
				TRCOption opt1 = factory.createTRCOption();
				opt1.setKey(Options.OPTION_BURST_SECONDS);
				opt1.setValue(String.valueOf(_optionsUI.getLimitTimeNb()));
				opt1.setConfiguration(config);
	
			} else {
				opt.setValue(Options.OPTION_VALUE_INVOCATIONS);
			}
	
			opt.setConfiguration(config);
	
			TRCOption opt1 = factory.createTRCOption();
			opt1.setKey(Options.OPTION_BURST_INVOCATIONS);
			opt1.setValue(String.valueOf(_optionsUI.getLimitInvocNb()));
			opt1.setConfiguration(config);
	
		} else if (_optionsUI.getLimitTime()) {
			TRCOption opt = factory.createTRCOption();
			opt.setKey(Options.OPTION_BURST_MODE);
			opt.setKey(Options.OPTION_VALUE_SECONDS);
			opt.setConfiguration(config);
	
			opt = factory.createTRCOption();
			opt.setKey(Options.OPTION_BURST_SECONDS);
			opt.setValue(String.valueOf(_optionsUI.getLimitTimeNb()));
			opt.setConfiguration(config);
	
		}
	}
	catch(ConcurrentModificationException exc)
	{
		exc.printStackTrace();
	}
		
}
protected void updateConfigData(EList options)
{
	if (options != null)
	{
		Iterator i = options.iterator();
		while (i.hasNext())
		{
			TRCOption option = (TRCOption)i.next();
			
			if(option.getKey().equals(Options.OPTION_BURST_MODE))
			{
				if(option.getValue().equals(Options.OPTION_VALUE_SECONDSANDINVOCATIONS))
				{
					_optionsUI.setLimitInvocations(true);
					_optionsUI.setLimitTime(true);				
				}
				else if(option.getValue().equals(Options.OPTION_VALUE_INVOCATIONS))
				{
					_optionsUI.setLimitInvocations(true);
					_optionsUI.setLimitTime(false);			
					
				}
				else if(option.getValue().equals(Options.OPTION_VALUE_SECONDS))
				{
					_optionsUI.setLimitInvocations(false);
					_optionsUI.setLimitTime(true);				
				}
				
			}
			else if(option.getKey().equals(Options.OPTION_BURST_INVOCATIONS))
			{
				_optionsUI.setLimitInvocNb(option.getValue());
			}
			else if(option.getKey().equals(Options.OPTION_BURST_SECONDS))
			{
				_optionsUI.setLimitTimeNb(option.getValue());
			}
							
		}
	}
}

	public void setVisible(boolean visible) {
		super.setVisible(visible);

		if (visible) {
			if (!((OpenProfAgentWizard)getWizard()).isProfilingAgent()) {
				this.getControl().setEnabled(false);
				this.getControl().setVisible(false);
				this.setDescription(UIPlugin.getResourceString("STR_LIMIT_IGNORED"));
			} else {
				this.getControl().setEnabled(true);
				this.getControl().setVisible(true);
				this.setDescription(UIPlugin.getResourceString("PROF_LIMIT_DESC"));
			}
		}
	}
}
