package org.eclipse.hyades.logging.parsers;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class ParserUtilities {

    private static ResourceBundle resourceBundle = null;

    public static String getResourceString(String key) {

        //Load ResourceBundle:
        if (resourceBundle == null) {

            //Workbench ResourceBundle:
            try {
                resourceBundle = LoggingParsersPlugin.getResourceBundle();
            }
            catch (Throwable e) {
            }

            //logutil.jar ResourceBundle:
            if (resourceBundle == null) {
                try {
                    resourceBundle = ResourceBundle.getBundle("org.eclipse.hyades.logging.parsers.properties.plugin", Locale.getDefault());
                }
                catch (MissingResourceException m) {
                    return key;
                }
            }
        }

        try {
            return (resourceBundle.getString(key.trim()).trim());
        }
        catch (Exception e) {
        }

        return key;
    }

    public static String getResourceString(String key, String argument) {
        return (getResourceString(key, new String[] { argument }));
    }

    public static String getResourceString(String key, String argumentA, String argumentB) {
        return (getResourceString(key, new String[] { argumentA, argumentB }));
    }

    public static String getResourceString(String key, String argumentA, String argumentB, String argumentC) {
        return (getResourceString(key, new String[] { argumentA, argumentB, argumentC }));
    }

    public static String getResourceString(String key, String[] arguments) {
        try {
            return (MessageFormat.format(getResourceString(key), arguments));
        }
        catch (Exception e) {
            return key;
        }
    }
}
