/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.preferences;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.hyades.log.ui.internal.util.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogAnalyzerFilterPrefPage implements SelectionListener{

	private boolean sevHasChanged = false;
	private CBEFilterUI _options;
	private IPreferenceStore _preferenceStore;
	private boolean filterHasChanged = false;
	
	public LogAnalyzerFilterPrefPage(IPreferenceStore preferenceStore) {
		super();
		_preferenceStore = preferenceStore;
	}
	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);

		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		composite.setLayout(layout);
		GridData data = GridUtil.createFill();
		composite.setLayoutData(data);

		_options = new CBEFilterUI();
		_options.createControl(composite);

		initializeValues();
		_options.addListener(this);		

		WorkbenchHelp.setHelp(composite, ContextIds.ACTLOG_PREF_FILTER_PROPERTIES);

		return composite;
	}
	/**
	 * Returns preference store that belongs to the our plugin.
	 * This is important because we want to store
	 * our preferences separately from the desktop.
	 *
	 * @return the preference store for this plugin
	 */
	protected IPreferenceStore doGetPreferenceStore() {
		return LogUIPlugin.getDefault().getPreferenceStore();
	}
	public void init(IWorkbench workbench) {
	}
	/**
	 * Initializes states of the controls using default values
	 * in the preference store.
	 */
	private void initializeDefaults() {
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
		_options.initializeValues(true);
	}
	/**
	 * Initializes states of the controls from the preference store.
	 */
	private void initializeValues() {
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();

		_options.initializeValues(false);
	}
	/**
	 * Does anything necessary because the default button has been pressed.
	 */
	protected void performDefaults() {
		initializeDefaults();
	}
	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		storeValues();
		LogUIPlugin.getDefault().savePluginPreferences();
		_options.removeListener(this);		
		if(filterHasChanged){	
			LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(RecordChangeEvent.FILTER_COL_CHANGE, this));
		}
		if(sevHasChanged){	
			LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(RecordChangeEvent.FILTER_SEV_CHANGE, this));
		}
		filterHasChanged = false;
		sevHasChanged = false;
		
		return true;
	}

	public boolean performApply(){

		storeValues();
		LogUIPlugin.getDefault().savePluginPreferences();		
		if(filterHasChanged){	
			LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(RecordChangeEvent.FILTER_COL_CHANGE, this));
		}

		if(sevHasChanged){	
			LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(RecordChangeEvent.FILTER_SEV_CHANGE, this));
		}
		
		filterHasChanged = false;
		sevHasChanged = false;
		
		return true;
	
	}
	
	/**
	 * Stores the values of the controls back to the preference store.
	 */
	private void storeValues() {
		boolean flag = _options.storeValues(_preferenceStore);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) {
		Widget widget = e.widget;
		if(widget instanceof Button && ((((Button)widget).getStyle() & SWT.CHECK)==SWT.CHECK)){
			sevHasChanged = true;		
		}
		else if (widget==_options.getControl()){
			sevHasChanged = true;
			filterHasChanged = true;						
		}
		else{
			filterHasChanged = true;
		}

	}

}