/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.hyades.analysis.engine.AnalysisEngineConstants;
import org.eclipse.hyades.analysis.engine.AnalysisEnginePlugin;
import org.eclipse.hyades.log.ui.internal.preferences.*;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

/**
 * 
 */
public class SymptomDBDialog extends Dialog {
	
	private SymptomDBUI _options;

	private java.lang.String _title;
	/**
	 * CoulmnsDialog constructor comment.
	 * @param windowTitle java.lang.String
	 * @param windowImage com.ibm.swt.graphics.Image
	 */
	public SymptomDBDialog(Shell shell, String windowTitle, Image windowImage) {
		super(shell);
		_title = windowTitle;
		setDefaultImage(windowImage);
	}
	/**
	 * Configures the given shell in prepartaion for opening this window
	 * in it.
	 * <p>
	 * The default implementation of this framework method
	 * sets the shell's image and gives it a grid layout. 
	 * Subclasses may extend or reimplement.
	 * </p>
	 * 
	 * @param newShell the shell
	 */
	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(_title);
	}
	/**
	 * Creates and returns the contents of the upper part 
	 * of the dialog (above the button bar).
	 *
	 * Subclasses should overide.
	 *
	 * @param the parent composite to contain the dialog area
	 * @return the dialog area control
	 */
	protected Control createDialogArea(Composite parent) {
		Composite result = (Composite) super.createDialogArea(parent);

		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		result.setLayout(layout);

		_options = new SymptomDBUI();
		_options.createControl(result);

		String path = AnalysisEnginePlugin.getPlugin().getPreferenceStore().getString(AnalysisEngineConstants.SYMPTOM_DB_PATH);
		_options.addDBPath(path);

		return result;
	}
	/**
	* Notifies that the ok button of this dialog has been pressed.
	* <p>
	* The default implementation of this framework method sets
	* this dialog's return code to <code>Window.OK</code>
	* and closes the dialog. Subclasses may override.
	* </p>
	*/
	protected void okPressed() {

		_options.storeValues(AnalysisEnginePlugin.getPlugin().getPreferenceStore());

		super.okPressed();
	}

}