/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.wizards;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.LogUIPluginImages;
import org.eclipse.hyades.log.ui.internal.util.LogUIConstants;
import org.eclipse.hyades.log.ui.internal.util.TraceMergeUI;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;

public class ImportLogLocationPage extends WizardPage implements Listener {

    private TraceLocationUI locationUI;
    private TraceMergeUI mergeUI;
    private TRCAgentProxy currentAgentProxy;

    public ImportLogLocationPage() {
        super("ImportLogFilePage1");

        setTitle(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_DES_TITLE"));

        setDescription(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_DES_DESC"));

        setImageDescriptor(LogUIPluginImages.getImageDescriptor(LogUIPluginImages.IMG_IMPORT_WIZ_BAN));
    }
    public void createControl(Composite parent) {
        GridLayout layout;

        Composite btnGroup = new Composite(parent, SWT.NONE);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 0;
        btnGroup.setLayout(layout);
        btnGroup.setLayoutData(GridUtil.createFill());

        locationUI = new TraceLocationUI();
        locationUI.createControl(btnGroup);

        locationUI.setLocation(LogUIConstants.LOG_ANALYZER_PRJ);

        locationUI.getLocationLabel().setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_DES_PROJECT"));

        locationUI.getLocation().addListener(SWT.Modify, this);
        locationUI.getMonitor().addListener(SWT.Modify, this);

        Label space = new Label(btnGroup, SWT.NONE);
        GridData data = new GridData(GridData.FILL_HORIZONTAL);

        mergeUI = new TraceMergeUI();
        mergeUI.createControl(btnGroup);
        mergeUI.getTree().addListener(SWT.Selection, this);
		
		mergeUI.getMergeButton().addListener(SWT.Selection, this);
        setControl(btnGroup);
        
     }
    
    public boolean finish() {
        // Set sort by TimeStamp if sort order not already specified.
        IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
        String sortBy = store.getString(LogUIConstants.PD_SORT_LOG_OPTIONS);
        if (sortBy == null || sortBy.equals("")) {
            store.setValue(LogUIConstants.PD_SORT_LOG_OPTIONS, "TimeStamp");
        }

        return true;
    }
    public void handleEvent(Event event) {
        if (event.type == SWT.Modify) {
            setPageComplete(!locationUI.getLocation().getText().trim().equals("") && !locationUI.getMonitor().getText().trim().equals(""));
        }
        else if (event.widget == mergeUI.getMergeButton()) {
				mergeUI.getTree().setEnabled(mergeUI.getMergeButton().getSelection());
				if(mergeUI.getMergeButton().getSelection()){           
					TreeItem[] sel = mergeUI.getTree().getSelection();
					if(sel.length > 0){				
						TreeItem selection = (TreeItem)sel[0];
						if(selection!=null && selection.getData()!=null){				
							if(selection.getData() instanceof TRCAgentProxy){
								setPageComplete(!locationUI.getLocation().getText().trim().equals("") && !locationUI.getMonitor().getText().trim().equals(""));
								currentAgentProxy = (TRCAgentProxy)selection.getData();
								return; 
														
							}else{
								setPageComplete(false);
							}
						}else{
							setPageComplete(false);
						}
					}
					else{					
						setPageComplete(false);					
					}
				}
				else{
					setPageComplete(!locationUI.getLocation().getText().trim().equals("") && !locationUI.getMonitor().getText().trim().equals(""));				
				}
				
				currentAgentProxy = null;				
        }
        else{
			
			TreeItem[] sel = mergeUI.getTree().getSelection();
			if(sel.length > 0){
				TreeItem selection = (TreeItem)sel[0];
				if(selection!=null && selection.getData()!=null){				
					if(selection.getData() instanceof TRCAgentProxy){
						TRCMonitor monitor = (TRCMonitor)((TRCAgentProxy)selection.getData()).getProcessProxy().getNode().getMonitor();
						locationUI.setMonitor(monitor.getName());
						String path = resourcePath(monitor.eResource().getURI());
						IWorkspace workbench = ResourcesPlugin.getWorkspace();				
						IPath filePath = new Path(path);
						IResource fres = workbench.getRoot().findMember(filePath);
						if (fres != null && fres.exists()) {
							locationUI.setLocation(fres.getProject().getName());

						}
						setPageComplete(!locationUI.getLocation().getText().trim().equals("") && !locationUI.getMonitor().getText().trim().equals(""));
						currentAgentProxy = (TRCAgentProxy)selection.getData();
						return;					
					}else{
						setPageComplete(false);
					}
				}
			
        	}
			currentAgentProxy = null;
        }        	
        

    }

    public String getProject() {
        return locationUI.getLocation().getText().trim();
    }
    public String getMonitor() {
        return locationUI.getMonitor().getText().trim();
    }

    public TRCAgentProxy getAgentProxy() {
		return currentAgentProxy;		
    }
    
    public boolean getSelection(){
		return mergeUI.getMergeButton().getSelection();
    }

	private String resourcePath(URI uri)
	{
	   String path = uri.path();
  
	   if(path.startsWith("/resource"))
		 return path.substring(9);
   	  
	   if(path.startsWith("platform:/resource"))
		 return path.substring(18);

	   return path;  
	}

    /*public boolean getAppendValue() {
        return mergeUI.getAppendValue();
    }*/
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#setVisible(boolean)
	 */
	public void setVisible(boolean visible) {

		super.setVisible(visible);
		boolean isLocalHost = ((ImportLogWizard) getWizard()).isLocalHost();
		if(visible){
			if(!isLocalHost){		
				mergeUI.getMergeButton().setEnabled(false);			
			}
			else{
				mergeUI.getMergeButton().setEnabled(true);			
			}
		}
	}

}
