/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.hyades.sdb.internal.util.TString;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class ImportLogUserPage extends WizardPage implements Listener, ModifyListener, ISetLastWasHome {
    private Hashtable _filtersTable = new Hashtable();
    private Map controlLookup = new HashMap();
    private ArrayList _idList = new ArrayList();
    private ArrayList _fieldList = new ArrayList();
    private ArrayList _buttonList = new ArrayList();

    private String _logParserId;
    //private boolean isLocal = false;
    private String lastWasHome = "";
    private String prefix = "ImportLogFile.";
    private String host = "";
    private boolean bTextHasChanged = false;

    private Shell shell;

    public ImportLogUserPage(IWorkbench aWorkbench, IStructuredSelection selection) {

        super("ImportLogUserPage");

        setTitle(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_LOC_TITLE"));

        setDescription(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_LOC_DESC"));

        setImageDescriptor(LogUIPluginImages.getImageDescriptor(LogUIPluginImages.IMG_IMPORT_WIZ_BAN));

        shell = aWorkbench.getActiveWorkbenchWindow().getShell();
    }
    public boolean isPageComplete() {

		Iterator iter =  controlLookup.values().iterator();
		while (iter.hasNext()){
			IImportWizardWidget widget = (IImportWizardWidget)iter.next();
			if (!(widget.isValid())) return false;
		}

        return true;

    }
    
    public void createControl(Composite parent) {
        _idList.clear();
        _filtersTable.clear();
        _fieldList.clear();
        _buttonList.clear();
        controlLookup.clear();
        
        Composite composite = new Composite(parent, SWT.NULL);
        GridLayout layout = new GridLayout();
        
        layout.numColumns = 2;
        
        composite.setLayout(layout);
        composite.setLayoutData(GridUtil.createFill());
        
        LogParserItem item = ((ImportLogWizard) getWizard()).getLogParser();
        ArrayList fields = item.getFields();
        
        prefix = ((ImportLogWizard) getWizard()).getHostName() + "." +  ((ImportLogWizard) getWizard()).getLogAgentName() +".";
        
        for (int idx = 0; idx <fields.size(); idx++) {
        	
            ParserField field = (ParserField) fields.get(idx);            
			if(field!=null){                        
				createWidget(composite, field);     
				_idList.add(field.getId());
			}
        }

        setControl(composite);

    }

	protected void createVerticalSpace(Composite comp, int colSpan){
		Label label = new Label(comp, SWT.NONE);
		GridData gd = new GridData();
		gd.horizontalSpan = colSpan;
		label.setLayoutData(gd);
	}
	 
    public void createWidget(Composite composite, ParserField field){
		IImportWizardWidget widget = null;
		
    	String trim = field.getUiType().trim();
    	if (trim.equals("combobox"))
			widget = new ImportWizardComboBox();
    	else if (trim.equals("checkbox"))
			widget = new ImportWizardCheckBox();
    	else if (trim.equals("radio"))
			widget = new ImportWizardRadioButton();
    	else if (trim.equals("text_area"))
    		widget = new ImportWizardTextArea();
    	else{
    		widget = new ImportWizardTextField(_filtersTable, this);
    	}
		widget.createControl(composite, field, prefix);
		if (widget instanceof ImportWizardTextField)	{
    		ImportWizardTextField textField = (ImportWizardTextField)widget;
    		textField.getText().addModifyListener(this);
			_buttonList.add(((ImportWizardTextField)widget).getBtn());
			_fieldList.add(field);   		
		}
		
		controlLookup.put(field.getId(), widget);
    }

 	private void initializeTextFields(){

		prefix = ((ImportLogWizard) getWizard()).getHostName() + "." +  ((ImportLogWizard) getWizard()).getLogAgentName() +".";

		// Initialize text fields with previous values from the preference store, if any exists.
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
            
		String previousValue = "";
		Text text = null;
		ParserField field = null;
		
		for (int idx = 0; idx <_fieldList.size(); idx++) {
		
			field = (ParserField)_fieldList.get(idx);
			text = ((ImportWizardTextField)controlLookup.get(field.getId())).getText();
			previousValue = store.getString(prefix + field.getId());
			if (previousValue != null && !previousValue.equals(""))
				text.setText(previousValue);
			else
				text.setText(field.getDefaultValue());			
		
		}
		bTextHasChanged = false;
 	
 	}
    public void initializePage() {

        if(!bTextHasChanged){
        	initializeTextFields();
        }
        setPageComplete(isPageComplete());
    }

    public Hashtable getUserInput() {
        Hashtable table = new Hashtable();
		Iterator iter =  controlLookup.keySet().iterator();		
		while (iter.hasNext()){		
			String id = (String)iter.next();
			IImportWizardWidget widget = (IImportWizardWidget)controlLookup.get(id);
			table.put(id, widget.getValue());
		}

        return table;
    }
    
    public ArrayList getIndexList(){
    	return _idList;
    }
    
    

    /**
     * 
     */
    public boolean finish() {
        // Save the current value in the preference store.
        //Hashtable table = new Hashtable();

		ParserField field = null;
		Text text = null;
		for (int idx = 0; idx <_fieldList.size(); idx++) {
		
			field = (ParserField)_fieldList.get(idx);
			text = ((ImportWizardTextField)controlLookup.get(field.getId())).getText();
			IImportWizardWidget widget = (IImportWizardWidget)controlLookup.get(field.getId());

			if(field.useBrowse()    
			&& ((ImportLogWizard) getWizard()).isLocalHost()){
				if(!(new File(widget.getValue()).exists())){
					String message = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_NO_FILE_EXISTS");
					message = TString.change(message, "%1", widget.getValue());
					MessageDialog.openError(getShell(), LogUIPlugin.getResourceString("LOGGING_MESSAGE"), message);
					return false;
				}
			}

			if (widget.isValid()){						
                IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
                store.setValue(prefix + field.getId(), widget.getValue());
            }
            
		}
        return true;
    }

    public void handleEvent(Event event) {
/*        for (int idx = 0; idx < _buttonList.size(); idx++) {
            Button btn = (Button) _buttonList.get(idx);
            if (event.widget == btn) {
                Text text = (Text) _textEntries.get(idx);
                Object filters = _filtersTable.get(btn);
                if (filters != null) {
                    FileDialog fileDialog = new FileDialog(getShell());
                    fileDialog.setFilterPath(text.getText().trim());
                    fileDialog.setFilterExtensions(new String[] { filters.toString(), "*" });
                    fileDialog.open();

                    String fileName = fileDialog.getFileName();

                    if ((fileName != null) && (!fileName.trim().equals("")))
                        text.setText(fileDialog.getFilterPath().concat(File.separator).concat(fileName));

                }
                else {
                    DirectoryDialog directoryDialog = new DirectoryDialog(getShell());
                    directoryDialog.setMessage(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_LOC_BROWSE"));

                    if (text.getText().trim().length() > 0)
                        directoryDialog.setFilterPath(text.getText().trim());
                    else if (lastWasHome.trim().length() > 0)
                        directoryDialog.setFilterPath(lastWasHome.trim());

                    String wasHomeDir = directoryDialog.open();

                    if ((wasHomeDir != null) && (!wasHomeDir.trim().equals(""))) {
                        text.setText(wasHomeDir);
                        lastWasHome = wasHomeDir;
                    }

                }

                return;
            }
        }

        setPageComplete(isPageComplete());
*/        
    }
    public void modifyText(ModifyEvent e) {
        setPageComplete(isPageComplete());
		bTextHasChanged = true;
    }
    public void setVisible(boolean visible) {
        super.setVisible(visible);

        if (visible) {
            LogParserItem item = ((ImportLogWizard) getWizard()).getLogParser();

            if (_logParserId == null || !item.getId().equals(_logParserId) || (host != ((ImportLogWizard)getWizard()).getHostName())) {
                _logParserId = item.getId();
                initializePage();
            }
            enableButtons();
        }
    }

    public void enableButtons() {
        boolean isLocalHost = ((ImportLogWizard) getWizard()).isLocalHost();

        for (int idx = 0; idx < _buttonList.size(); idx++) {
            Button btn = (Button) _buttonList.get(idx);
            btn.setEnabled(isLocalHost);
        }

    }

	/**
	 * Returns the lastWasHome.
	 * @return String
	 */
	public String getLastWasHome() {
		return lastWasHome;
	}

	/**
	 * Sets the lastWasHome.
	 * @param lastWasHome The lastWasHome to set
	 */
	public void setLastWasHome(String lastWasHome) {
		this.lastWasHome = lastWasHome;
	}

}