/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.wizards;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.jface.preference.*;
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

/**
 *
 */
public class ImportWizardTextArea implements IImportWizardWidget {

	protected Text text;
	/**
	 * @see com.ibm.etools.pd.ras.wizard.IImportWizardWidget#getValue()
	 */
	public String getValue() {
		return text.getText().trim();
	}

	/**
	 * @see com.ibm.etools.pd.ras.wizard.IImportWizardWidget#createControl(Composite, ParserField, String)
	 */
	public void createControl(
		Composite composite,
		ParserField field,
		String prefix) {
            Label label = new Label(composite, SWT.NULL | SWT.WRAP);            
            GridData data = new GridData();
            data.widthHint = 400;
            data.horizontalSpan = 2;            
            label.setLayoutData(data);
            label.setText(field.getName());
            
            text = new Text(composite, SWT.BORDER | SWT.MULTI| SWT.H_SCROLL | SWT.V_SCROLL);
            
            data = new GridData();
            data.widthHint = 400;
            data.horizontalSpan = 2;            
            data.heightHint = 40;
            text.setLayoutData(data);
            text.setToolTipText(field.getTooltip());
            
            // Get the previous value from the preference store, if one exists.
            IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
            
            String previousValue = store.getString(prefix + field.getId());
            if (previousValue != null && !previousValue.equals(""))
                text.setText(previousValue);
            else
                text.setText(field.getDefaultValue());

            
			
	}


	/**
	 * @see com.ibm.etools.pd.ras.wizard.IImportWizardWidget#isValid()
	 */
	public boolean isValid() {
        if (text.getVisible() && text.getText().trim().equals(""))
           return false;
		
		return true;
	}

	/**
	 * Returns the text.
	 * @return Text
	 */
	public Text getText() {
		return text;
	}

	/**
	 * Sets the text.
	 * @param text The text to set
	 */
	public void setText(Text text) {
		this.text = text;
	}


}
