/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.wizards;

import org.eclipse.core.runtime.*;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.jface.resource.*;
import org.eclipse.ui.model.*;

/**
 *
 */
public class LogWizardElementBase
	implements IWorkbenchAdapter, IAdaptable {
		
	private ImageDescriptor imageDescriptor;
	private String description;
	private String name;
	private String parserId;
	private IConfigurationElement parserConfigurationElement;


	public LogWizardElementBase(String name) {
		this.name = name;
	}
	
    public Parser getParserInstance() {
        try {

            if (parserConfigurationElement == null)
                return null;

            Object elem = parserConfigurationElement.createExecutableExtension("class");
            if (elem instanceof Parser) {

                return (Parser) elem;

            }
            else {
                System.err.println("LogParser should extend LogParser interface ! ");
            }
        }
        catch (CoreException exc) {
            return null;
        }

        return null;

    }

	/**
	 * Returns the name.
	 * @return String
	 */
	public String getName() {
		return name;
	}

	/**
	 * Returns the parserId.
	 * @return String
	 */
	public String getParserId() {
		return parserId;
	}

	/**
	 * Sets the name.
	 * @param name The name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Sets the parserId.
	 * @param parserId The parserId to set
	 */
	public void setParserId(String parserClass) {
		this.parserId = parserClass;
	}


	/**
	 * Returns the parserConfigurationElement.
	 * @return IConfigurationElement
	 */
	public IConfigurationElement getParserConfigurationElement() {
		return parserConfigurationElement;
	}

	/**
	 * Sets the parserConfigurationElement.
	 * @param parserConfigurationElement The parserConfigurationElement to set
	 */
	public void setParserConfigurationElement(IConfigurationElement parserConfigurationElement) {
		this.parserConfigurationElement = parserConfigurationElement;
	}

	/**
	 * Returns the description.
	 * @return String
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * Returns the imageDescriptor.
	 * @return ImageDescriptor
	 */
	public ImageDescriptor getImageDescriptor() {
		return imageDescriptor;
	}

	/**
	 * Returns the name of this wizard element.
	 */
	public ImageDescriptor getImageDescriptor(Object element) {
		return imageDescriptor;
	}
	
	/**
	 * Sets the description.
	 * @param description The description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * Sets the imageDescriptor.
	 * @param imageDescriptor The imageDescriptor to set
	 */
	public void setImageDescriptor(ImageDescriptor imageDescriptor) {
		this.imageDescriptor = imageDescriptor;
	}

	/**
	 * @see org.eclipse.ui.model.IWorkbenchAdapter#getChildren(Object)
	 */
	public Object[] getChildren(Object o) {
			return new Object[0];
	}

	/**
	 * @see org.eclipse.ui.model.IWorkbenchAdapter#getLabel(Object)
	 */
	public String getLabel(Object o) {
		return name;
	}

	/**
	 * @see org.eclipse.ui.model.IWorkbenchAdapter#getParent(Object)
	 */
	public Object getParent(Object o) {
		return null;
	}

	/**
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(Class)
	 */
	public Object getAdapter(Class adapter) {
		if (adapter == IWorkbenchAdapter.class) {
			return this;
		}
		return Platform.getAdapterManager().getAdapter(this, adapter);
	}

}
