/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.wizard;

import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.hyades.sdb.internal.SDbPlugin;

/**
 * Standard workbench wizard for importing resources from a symptom db xml file
 * into the workspace.
 */
public class ImportSymptomDBWizard extends Wizard
								  implements IImportWizard
{
	private IWorkbench workbench;
	private IStructuredSelection selection;
	private ImportSymptomDBPage2 page2;	
	private boolean success = true;
/**
 * Creates a wizard for importing resources into the workspace from
 * a zip file.
 */
public ImportSymptomDBWizard() {
	AbstractUIPlugin plugin = (AbstractUIPlugin) Platform.getPlugin(PlatformUI.PLUGIN_ID);
	IDialogSettings workbenchSettings = plugin.getDialogSettings();
	IDialogSettings section = workbenchSettings.getSection("ImportSymptomDBWizard");//$NON-NLS-1$
	if(section == null)
		section = workbenchSettings.addNewSection("ImportSymptomDBWizard");//$NON-NLS-1$
	setDialogSettings(section);
}
/* (non-Javadoc)
 * Method declared on IWizard.
 */
public void addPages()
{
  	setWindowTitle(SDbPlugin.getResourceString("STR_IMPORT_SYMPTOM_DB_WIZARD_TITLE"));	
  		
	super.addPages();
	page2 = new ImportSymptomDBPage2(workbench,selection);
	addPage(page2);
}
/* (non-Javadoc)
 * Method declared on IWorkbenchWizard.
 */
public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
	this.workbench = workbench;
	selection = currentSelection;

//	setDefaultPageImageDescriptor(RASPluginImages.getImageDescriptor(RASPluginImages.IMG_UI_WZ_LAUNCH));
	setNeedsProgressMonitor(true);
}
/* (non-Javadoc)
 * Method declared on IWizard.
 */
public boolean performFinish()
{
	return page2.finish();
}

}
