/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui.internal.model;

import org.eclipse.hyades.sd.ui.internal.util.*;
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;

public class ColumnPassage {

	/* Passage Type
		22 - bridgeLeftRight
		23 - bridgeRightLeft
		24 - bridgeLeftRightDashed
		25 - bridgeRightLeftDashed  */
	int type;
	boolean logRecordConection;
	NodeConnection nodeConnection;
	int passagePosition;
			
	/**
	 * Constructor for ColumnPasage
	 */
	public ColumnPassage(int t, NodeConnection nc,boolean log){
		super();
		type = t;
		nodeConnection = nc;
		logRecordConection = log;
		passagePosition = nodeConnection.getStartIncrementValue();
	}

	public void drawSelf(GC gc, int width, int timeUnit, int boxSpace, int startPosition, int xOffset) { 

		Color originalColor = gc.getForeground();
		if(nodeConnection.isSelected())
		{
			if (!logRecordConection)
		   		gc.setForeground(LogCDrawUtils.getForegroundSelectedColor());
			else
				gc.setForeground(LogCDrawUtils.getLogHighLightColor());
		}
		else
		{
		   	if (!logRecordConection)
		   		gc.setForeground(LogCDrawUtils.getConnectionColor());
			else
				gc.setForeground(LogCDrawUtils.getLogConnectionColor());
		}
		
		int position = boxSpace + timeUnit * (passagePosition - startPosition);
		switch (type) {
			case (22) : //bridgeLeftRight
				gc.drawLine(xOffset, position, xOffset+width, position);
				break;
			case (23) : //bridgeRightLeft
				gc.drawLine(xOffset+width, position, xOffset, position);
				break;
			case (24) : //bridgeLeftRightDashed
				gc.setLineStyle(SWT.LINE_DOT);
				gc.drawLine(xOffset, position, xOffset+width, position);
				gc.setLineStyle(SWT.LINE_SOLID);
				break;
			case (25) : //bridgeRightLeftDashed
				gc.setLineStyle(SWT.LINE_DOT);
				gc.drawLine(xOffset+width, position, xOffset, position);
				gc.setLineStyle(SWT.LINE_SOLID);
				break;
			default :
				System.out.println("WRONG INDEX FOR PASSAGE!!!!!");
				break;
		}
		gc.setForeground(originalColor);
		originalColor.dispose();
	}
	
	public int getPassagePosition() {
		return passagePosition;
	}
	
	public void setPassagePosition(int position) {
		passagePosition=position;
	}
	public NodeConnection getNodeConnection(){
		return nodeConnection;
	}
	
	public void setSelected(boolean state){
	   nodeConnection.setSelected(state);	
	}

    public boolean isOver(int index){
	   return 	index>Math.min(nodeConnection.getSource().getContainer().getIndexInContainer(),
	            nodeConnection.getTarget().getContainer().getIndexInContainer()) && 
	            index <Math.max(nodeConnection.getSource().getContainer().getIndexInContainer(),
	            nodeConnection.getTarget().getContainer().getIndexInContainer());
	}
}
