/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui.internal.model;

/**
 * NodeContainer is a GraphNode, and can contain other nodes, which may themselves 
 * be containers. This would allow for drill down scenarios.
 */
public interface NodeContainer extends GraphNode
{
  /*
   * The following fields need to be part of an implementation
   *
  public GraphNode lastReadNode = null;
  public GraphNode internalNodes[] = new GraphNode[3];
  public int nextNewInternalNode = 0;
  */

  public GraphNode[] getInternalNodes();

  public void setInternalNodes(GraphNode[] nodes);

  public void addInternalNode(GraphNode node);

  public int getInternalNodeCount();
}
