/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui.internal.util;

import java.util.*;

import org.eclipse.hyades.sd.ui.*;
import org.eclipse.hyades.sd.ui.internal.model.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.dialogs.*;

public class SearchTab implements PaintListener {

	private GraphNode[] containers;
	private int containerCount;
	private int type;

	private GraphNode selectedNode = null;
	private DrawAreaFindDialog dialog = null;
	private Text fPatternText = null;
	private FilteredList list = null;
	private boolean initialSelection = true;
	
	/**
	 * A label provider for the elements list
	 */
	class ElementsLabelProvider extends LabelProvider {

		public String getText(Object element) {
			String label = "";
			if (type==GraphNode.OBJECT)
				label = ((GraphNode)element).getName()+":"+((GraphNode)element).getSecondaryName();
			else if (type==GraphNode.LOG)
				label = ((GraphNode)element).getName()+":"+((GraphNode)element).getShortName();
			else
				label = ((GraphNode)element).getName();
			return element == null ? "" : label;
		}
	}
		
	public SearchTab( GraphNode[] containers, int containerCount, int type, DrawAreaFindDialog dialog) {
		super();
		this.containers = containers;
		this.containerCount = containerCount;
		this.type = type;
		this.dialog = dialog;
	}

	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);

		GridLayout layout;
		GridData data;
		
		composite.addPaintListener(this);
		
		layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		composite.setLayout(layout);
		
		Label label = new Label(composite, SWT.NONE);
		label.setText(SDPlugin.getString("STR_NAME"));
		
		fPatternText = new Text(composite,SWT.BORDER);
		fPatternText.setLayoutData(GridUtil.createHorizontalFill());
		
		list = new FilteredList(composite, SWT.BORDER, new ElementsLabelProvider(), true, true, true);
		list.setLayoutData(GridUtil.createFill());
		list.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				// Workaround for FilteredList's default selection. Causes
				// problems with multiple tabs.
				if (!initialSelection)
					updateSelectedNode();
				initialSelection = false;
			}
			public void widgetDefaultSelected(SelectionEvent e) {
				// double-clicked
				dialog.okPressed();
			}
		});

		fPatternText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				list.setFilter(((Text)e.widget).getText());
				updateSelectedNode();
			}
		});

		loadList();
		return composite;
	}

	private void updateSelectedNode() {
		Object[] selection = list.getSelection();
		dialog.setSelectedNode(selection == null || selection.length == 0 ? null : (GraphNode)selection[0]);
	}

	public void loadList() {
		Vector fSearchList = new Vector();
		for (int i = 0; i < containerCount; i++) {
			if (containers[i]!=null && containers[i].getType() == type)
				fSearchList.add(containers[i]);	
		}
		list.setElements(fSearchList.toArray());
	}
	
	//when tab is selected
	public void paintControl(PaintEvent e){
		updateSelectedNode();
		fPatternText.setFocus();
	}
}
