/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui.internal.views;

import java.lang.reflect.*;

import org.eclipse.core.runtime.*;
import org.eclipse.emf.ecore.*;
import org.eclipse.hyades.sd.ui.*;
import org.eclipse.hyades.sd.ui.internal.model.*;
import org.eclipse.hyades.sd.ui.internal.util.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.*;
import org.eclipse.jface.operation.*;
import org.eclipse.jface.window.*;
import org.eclipse.swt.widgets.*;

public class SDViewerPage extends TraceViewerPage
{
  protected SDViewerUI sdViewerUI = null;
  protected Composite parent;
  protected int viewerType;
  protected IRunnableWithProgress op = null;
  protected IConfigurationElement correlationType=null;

  public SDViewerPage(EObject mofObject, TraceViewer _viewer)
  {
    super(mofObject,_viewer);
  }

  public void createControl(Composite parent)
  {
    this.parent = parent;
  }

  public Control getControl()
  {
    Control returnControl = null;
    if (LogCDrawUtils.getViewerType()==LogCDrawUtils.SD_VIEWER)//viewer == 1)
    {
       if(sdViewerUI == null)
	   	sdViewerUI = createEditorAndModel(((SDViewer)getTraceViewer()).getCurrentGraphType());
       returnControl = sdViewerUI.getControl();
       viewerType = LogCDrawUtils.SD_VIEWER;
    }
    
	setContextMenu(sdViewerUI.getCanvas(), sdViewerUI);
    
    return returnControl;
  }

  public void makeActions(String role)
  {
	getTraceViewer().makeActions();
  }

  public void setFocus()
  {
	getTraceViewer().setFocus();
  }

  public void setMOFObject(EObject object)
  {
    _mofObject = object;
  }

  public void update()
  {
    ((SDViewerUI) getControl()).updateUI();
  }

  private Graph getGraph(int graphType)
  {
  	if(LogCDrawUtils.getViewerType()==LogCDrawUtils.TABLE_VIEWER){
  	   //TABLE
  	   if (SDPlugin.getDefault().getPreferenceStore().getBoolean(SDConstants.FILTER_SELF_CALL))
  	      return Graph.getGraphFactory().createFilteredGraph(
  	      graphType,
          getMOFObject(),
          TableContentFactory.getContentFactory());
       else
  	      return Graph.getGraphFactory().createGraph(
  	      graphType,
          getMOFObject(),
          TableContentFactory.getContentFactory());
  	}else{
  	   //SD	
       if (SDPlugin.getDefault().getPreferenceStore().getBoolean(SDConstants.FILTER_SELF_CALL))
          return Graph.getGraphFactory().createFilteredGraph(
          graphType,
          getMOFObject(),
          GraphContentFactory.getContentFactory());
       else
          return Graph.getGraphFactory().createGraph(
          graphType,
          getMOFObject(),
          GraphContentFactory.getContentFactory());
  	}
  }

	private IExtension showCorrelationDialog() {
		IPluginRegistry registry = Platform.getPluginRegistry();
		IExtensionPoint point =	registry.getExtensionPoint("org.eclipse.hyades.logc.logInteractionView");//$NON-NLS-1$
		if (point != null) {
			IExtension[] extensions = point.getExtensions();

			LogCorrelationSelectionDialog logCorrelationSelectionDialog = new LogCorrelationSelectionDialog(null, extensions, this);
			logCorrelationSelectionDialog.open();

			if (logCorrelationSelectionDialog.getReturnCode() == Window.OK) {
				
				IConfigurationElement elem = logCorrelationSelectionDialog.getSelectedCorrelation();
				setCorrelationType(elem);
			}
		}
		return null;
	}
	
  public void loadModel(int graphType, IConfigurationElement correlation)
  {
  	setCorrelationType(correlation);
  	loadModel(graphType);  	
  }	
  
  public void loadModel(int graphType, boolean showCorrelationDialog)
  {
  	if ((graphType==Graph.LOGoverRECORD || graphType==Graph.THREADoverRECORD)  
  		&& showCorrelationDialog)
  	{
  		showCorrelationDialog();
  	}
  	loadModel(graphType);
  	
  }
  public void loadModel(int graphType)
  {
    ProgressMonitorDialog progressDialog = null;
     try {
       progressDialog = new ProgressMonitorDialog(getTraceViewer().getSite().getShell());
      if(op==null)
         op = new LoadThread(this,graphType,progressDialog.getProgressMonitor());
      progressDialog.setCancelable(true);
      progressDialog.run(false, true, op);
   } catch (InvocationTargetException e) {
     // handle exception
     load(graphType);
   } catch (InterruptedException e) {
     // handle cancelation
     if(progressDialog!=null)
        progressDialog.close();
     return;
   }
  }
  
  public class LoadThread implements IRunnableWithProgress{
	SDViewerPage sdPage;
   	   int graphType;
   	   IProgressMonitor monitor;
   	   public LoadThread(SDViewerPage page, int gt, IProgressMonitor mon){
   	   	  sdPage = page;
   	   	  graphType = gt;
   	   	  monitor = mon;
   	   }
   	   public void run(IProgressMonitor monitor){
   	   	  monitor.beginTask("",IProgressMonitor.UNKNOWN);
   	   	  sdPage.load(graphType);
   	   	  monitor.done();
   	   }
  }
  
  
  
  public void load(int graphType){
    if(LogCDrawUtils.getViewerType()==LogCDrawUtils.SD_VIEWER){
		sdViewerUI = createEditorAndModel(graphType);
       ((SDViewerUI) sdViewerUI.getControl()).goHome();
       viewerType = LogCDrawUtils.SD_VIEWER;
    }
  }

  private SDViewerUI createEditorAndModel(int graphType)
  {
    Graph graph = getGraph(graphType);

    if (sdViewerUI == null)
      return new SDViewerUI(parent, graph, this);

	sdViewerUI.reloadGraph(graph);
    return sdViewerUI;
  }
  
   public void dispose(){
       super.dispose();
       _mofObject = null;  
       if(sdViewerUI !=null)
		sdViewerUI.dispose();
       op = null;   
       
       correlationType = null;         
   }

	public IConfigurationElement getCorrelationType() {
		return correlationType;
	}

	public void setCorrelationType(IConfigurationElement correlationType) {
		this.correlationType = correlationType;
	}

	public SDViewerUI getSdViewerUI() {
		return sdViewerUI;
	}

	public void refreshPage() {
	}
	public void selectionChanged() {
	}
	public void update(boolean newPage) {
	}

	/**
	 * Contribute to the view popup menu
	 * @param menu
	 */
	public void fillContextMenu(IMenuManager menu)
	{	
		if(sdViewerUI != null)
		{
			sdViewerUI.fillContextMenu(menu);
		}
	}
	
	public boolean isEmpty()
	{
		//if the viewer is null, then the graph is empty
		if (sdViewerUI == null) return true;
		return sdViewerUI.isEmpty();
	}

}
