/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.manual.internal.editor;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.eclipse.hyades.test.common.internal.editor.TestSuiteForm;
import org.eclipse.hyades.test.manual.TestManualPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.util.NamedElementsSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class ManualForm 
extends TestSuiteForm
{
	/**
	 * Constructor for ManualForm
	 * @param junitEditorExtension
	 * @param widgetFactory
	 */
	public ManualForm(ManualEditorExtension httpEditorExtension, WidgetFactory widgetFactory)
	{
		super(httpEditorExtension, widgetFactory);
		setHeadingText(TestManualPlugin.getString("W_TST_SUITE"));
	}


	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestSuiteForm#registerHelp(int, java.lang.Object)
	 */
	protected void registerHelp(int flag, Object object)
	{
		switch(flag)
		{
			case HELP_FORM_CONTROL:
				break;
				
			case HELP_TEST_CASE_CONTROL:
				break;
				
			case HELP_TYPE_CONTROL:
				break;

			case HELP_FILE_CASE_CONTROL:
				break;
		}
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestSuiteForm#createTestCaseElementsSectionControl(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.util.NamedElementsSection)
	 */
	protected Control createTestCaseElementsSectionControl(Composite parent, NamedElementsSection testCaseElementsSection)
	{
		return testCaseElementsSection.createControl(parent, factory, TestManualPlugin.getString("W_TST_CASES"), TestManualPlugin.getString("EDT_TST_CASE_DSC"));
	}
}
