/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.cbe;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

import org.eclipse.hyades.loaders.hierarchy.ForwardReference;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.loaders.util.XMLFragmentLoader;
import org.eclipse.hyades.models.cbe.CBEAssociationEngine;
import org.eclipse.hyades.models.cbe.CBEFactory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
public class XMLAssociationEngineLoader extends Stack implements XMLFragmentLoader {
    //~ Instance fields ----------------------------------------------------------------------------

    private CBEAssociationEngine rootElement;
    private EObject newCurrentChild;
    private HierarchyContext context;
    private List forwardReferences;

    //~ Constructors -------------------------------------------------------------------------------

    public XMLAssociationEngineLoader() {
        super();
        forwardReferences = new ArrayList();
    }

    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {
        EStructuralFeature feature;

        feature = rootElement.eClass().getEStructuralFeature(name);

        if (feature != null) {
            if (feature instanceof EAttribute) {
                Object newValue = EcoreUtil.createFromString((EDataType) feature.getEType(), value);

                if (newValue != null) {
                    rootElement.eSet(feature, newValue);
                }

                return;
            } else if (feature instanceof EReference) {
                addForwardReference(feature, value);

                return;
            }
        }
    }

    public void addCharacters(char[] data, int offset, int length) {
    }

    public void addYourselfInContext() {
        if (context.getAgent() == null) {
            LoadersUtils.createAgent(context);
        }

        context.getAgent().eResource().getContents().add(rootElement);
        processForwardReferences(context);
    }

    public void cleanUp() {
        context=null;
        forwardReferences=null;
        newCurrentChild=null;
        rootElement=null;
        clear();
    }

    public void endChild(String name) {
    }

    public void initialize(HierarchyContext context, String name) {
        this.context = context;
        forwardReferences.clear();
        rootElement = CBEFactory.eINSTANCE.createCBEAssociationEngine();
        clear();
    }

    public void startChild(String name) {
    }

    private void addForwardReference(EStructuralFeature feature, String value) {
        forwardReferences.add(new ForwardReference(rootElement, feature, value));
    }

    private void processForwardReferences(HierarchyContext context) {
        for (Iterator iter = forwardReferences.iterator(); iter.hasNext();) {
            ForwardReference ref = (ForwardReference) iter.next();
            EObject o = (EObject) LookupServiceExtensions.getInstance().locate(context, ref.getRefId());

            if (o != null) {
                if (ref.getFeature().isMany()) {
                    ((EList) ref.getObject().eGet(ref.getFeature())).add(o);
                } else {
                    ref.getObject().eSet(ref.getFeature(), o);
                }
            } else {
                context.getGlobalForwardReferences().add(ref);
            }
        }
    }
}
