/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.cbe.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.cbe.CBEAssociatedEvent;
import org.eclipse.hyades.models.cbe.CBEAssociationEngine;
import org.eclipse.hyades.models.cbe.CBEDefaultEvent;
import org.eclipse.hyades.models.cbe.CBEPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Associated Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBEAssociatedEventImpl#getResolvedEvents <em>Resolved Events</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBEAssociatedEventImpl#getAssociationEngine <em>Association Engine</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CBEAssociatedEventImpl extends EObjectImpl implements CBEAssociatedEvent {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The cached value of the '{@link #getResolvedEvents() <em>Resolved Events</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResolvedEvents()
	 * @generated
	 * @ordered
	 */
	protected EList resolvedEvents = null;

	/**
	 * The cached value of the '{@link #getAssociationEngine() <em>Association Engine</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAssociationEngine()
	 * @generated
	 * @ordered
	 */
	protected CBEAssociationEngine associationEngine = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CBEAssociatedEventImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return CBEPackage.eINSTANCE.getCBEAssociatedEvent();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getResolvedEvents() {
		if (resolvedEvents == null) {
			resolvedEvents = new EObjectResolvingEList(CBEDefaultEvent.class, this, CBEPackage.CBE_ASSOCIATED_EVENT__RESOLVED_EVENTS);
		}
		return resolvedEvents;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CBEAssociationEngine getAssociationEngine() {
		if (associationEngine != null && associationEngine.eIsProxy()) {
			CBEAssociationEngine oldAssociationEngine = associationEngine;
			associationEngine = (CBEAssociationEngine)EcoreUtil.resolve(associationEngine, this);
			if (associationEngine != oldAssociationEngine) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, CBEPackage.CBE_ASSOCIATED_EVENT__ASSOCIATION_ENGINE, oldAssociationEngine, associationEngine));
			}
		}
		return associationEngine;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CBEAssociationEngine basicGetAssociationEngine() {
		return associationEngine;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAssociationEngine(CBEAssociationEngine newAssociationEngine) {
		CBEAssociationEngine oldAssociationEngine = associationEngine;
		associationEngine = newAssociationEngine;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_ASSOCIATED_EVENT__ASSOCIATION_ENGINE, oldAssociationEngine, associationEngine));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CBEPackage.CBE_ASSOCIATED_EVENT__RESOLVED_EVENTS:
				return getResolvedEvents();
			case CBEPackage.CBE_ASSOCIATED_EVENT__ASSOCIATION_ENGINE:
				if (resolve) return getAssociationEngine();
				return basicGetAssociationEngine();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CBEPackage.CBE_ASSOCIATED_EVENT__RESOLVED_EVENTS:
				getResolvedEvents().clear();
				getResolvedEvents().addAll((Collection)newValue);
				return;
			case CBEPackage.CBE_ASSOCIATED_EVENT__ASSOCIATION_ENGINE:
				setAssociationEngine((CBEAssociationEngine)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CBEPackage.CBE_ASSOCIATED_EVENT__RESOLVED_EVENTS:
				getResolvedEvents().clear();
				return;
			case CBEPackage.CBE_ASSOCIATED_EVENT__ASSOCIATION_ENGINE:
				setAssociationEngine((CBEAssociationEngine)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CBEPackage.CBE_ASSOCIATED_EVENT__RESOLVED_EVENTS:
				return resolvedEvents != null && !resolvedEvents.isEmpty();
			case CBEPackage.CBE_ASSOCIATED_EVENT__ASSOCIATION_ENGINE:
				return associationEngine != null;
		}
		return eDynamicIsSet(eFeature);
	}

} //CBEAssociatedEventImpl
