/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner.ui.util;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.Map;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class BaseCardLayout 
extends CardLayout
{
	private Map tab;
	
	/**
	 * Constructor for BaseCardLayout.
	 */
	public BaseCardLayout()
	{
		super();
		tab = new HashMap();
	}

	/**
	 * Constructor for BaseCardLayout.
	 * @param hgap
	 * @param vgap
	 */
	public BaseCardLayout(int hgap, int vgap)
	{
		super(hgap, vgap);
	}

	/**
	 * @see LayoutManager2#addLayoutComponent(Component, Object)
	 */
	public void addLayoutComponent(Component comp, Object constraints)
	{
		super.addLayoutComponent(comp, constraints);
		tab.put(constraints, comp);
	}

	/**
	 * @see CardLayout#show(Container, String)
	 */
	public Component showAndTell(Container parent, String name)
	{
		super.show(parent, name);
		return getComponent(name);
	}
	
	public Component getComponent(String name)
	{
		return (Component)tab.get(name);
	}
}
