/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.util.Iterator;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.test.ui.internal.wizard.ReportWizard;

/*
* CONTEXT_ID owiz0000 for new wizard action
*/

public class OpenReportAction extends Action
{
  private IStructuredSelection selection;
  
  public OpenReportAction()
  {
	super(TestUIPlugin.getString("REPORT_TEXT"));
	WorkbenchHelp.setHelp(this, TestUIPlugin.getID() + ContextIds.OPEN_REPORT_ACT);												
	

  }  
  
  public void run()
  {
	ReportWizard wizard = new ReportWizard();
	wizard.init(PlatformUI.getWorkbench(), selection);

	WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), wizard);
	dialog.open();
	wizard.dispose();	
	
	selection = null;		
  }
 
  public void selectionChanged(IStructuredSelection structuredSelection)
  {
  	selection = structuredSelection;
  }
  
  
  
  public boolean isApplicableForSelection()
  {
 	  if(selection == null || selection.isEmpty())
	     return false;
	     
  	  Iterator iterator = ((IStructuredSelection) selection).iterator();
  	  while(iterator.hasNext())
  	  {
  	  	Object elem = iterator.next();
  	  	
  	  	if(!(elem instanceof TPFTestSuite) && !(elem instanceof TPFTestCase))
  	  	  return false;
  	  }
      
      return true;
  }

}
