package org.eclipse.hyades.internal.config.generator;

import com.ibm.etools.xmlschema.beans.ComplexType;

/**
* This class represents the complex type <Agent>
*/
public class Agent extends ComplexType
{
  public Agent()
  {
  }
  
  public void setOption(int index, Option Option)
  {
    setElementValue(index, "Option", Option);
  }
  
  public Option getOption(int index)
  {
    return (Option) getElementValue("Option", "Option", index);
  }
  
  public int getOptionCount()
  {
    return sizeOfElement("Option");
  }
  
  public boolean removeOption(int index)
  {
    return removeElement(index, "Option");
  }
  
  public void setConfiguration(String configuration)
  {
    setAttributeValue("configuration", configuration);
  }
  
  public String getConfiguration()
  {
    return getAttributeValue("configuration");
  }
  
  public boolean removeConfiguration()
  {
    return removeAttribute("configuration");
  }
  
  public void setName(String name)
  {
    setAttributeValue("name", name);
  }
  
  public String getName()
  {
    return getAttributeValue("name");
  }
  
  public boolean removeName()
  {
    return removeAttribute("name");
  }
  
  public void setType(String type)
  {
    setAttributeValue("type", type);
  }
  
  public String getType()
  {
    return getAttributeValue("type");
  }
  
  public boolean removeType()
  {
    return removeAttribute("type");
  }
  
  public void setDataChannelSize(String dataChannelSize)
  {
    setAttributeValue("dataChannelSize", dataChannelSize);
  }
  
  public String getDataChannelSize()
  {
    return getAttributeValue("dataChannelSize");
  }
  
  public boolean removeDataChannelSize()
  {
    return removeAttribute("dataChannelSize");
  }
  
  public void setLogFile(String logFile)
  {
    setAttributeValue("logFile", logFile);
  }
  
  public String getLogFile()
  {
    return getAttributeValue("logFile");
  }
  
  public boolean removeLogFile()
  {
    return removeAttribute("logFile");
  }
  
  public void setClient(String client)
  {
    setAttributeValue("client", client);
  }
  
  public String getClient()
  {
    return getAttributeValue("client");
  }
  
  public boolean removeClient()
  {
    return removeAttribute("client");
  }
  
}

