/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.java.internal.junit.editor;

import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.internal.dialog.InvokedTestSelectionDialog;
import org.eclipse.hyades.test.common.internal.editor.BehaviorForm;
import org.eclipse.hyades.test.common.internal.editor.BehaviorSection;
import org.eclipse.hyades.test.common.internal.editor.LoopDetailPage;
import org.eclipse.hyades.test.common.internal.editor.TestInvocationDetailPage;
import org.eclipse.hyades.test.common.internal.editor.TestSuiteEditorExtension;
import org.eclipse.hyades.test.java.TestJavaPlugin;
import org.eclipse.hyades.test.java.internal.util.ContextIds;
import org.eclipse.hyades.test.java.internal.util.TestJavaUtil;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class JUnitBehaviorForm
extends BehaviorForm
{
	/**
	 * Constructor for JUnitBehaviorForm
	 * @param junitEditorExtension
	 * @param widgetFactory
	 */
	public JUnitBehaviorForm(JUnitEditorExtension junitEditorExtension, WidgetFactory widgetFactory)
	{
		super(junitEditorExtension, widgetFactory);
		setHeadingText(TestJavaPlugin.getString("EDT_JUNIT_TTL"));
	}
	
	protected JUnitBehaviorForm(TestSuiteEditorExtension testSuiteEditorExtension, WidgetFactory widgetFactory)
	{
		super(testSuiteEditorExtension, widgetFactory);
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.BehaviorForm#createBehaviorSection()
	 */
	protected BehaviorSection createBehaviorSection()
	{
		return new JUnitBehaviorSection(this);
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestCasesForm#registerHelp(int, java.lang.Object)
	 */
	protected void registerHelp(int flag, Object object)
	{
		switch(flag)
		{
			case HELP_NAMED_ELEMENT_CONTROL:
				WorkbenchHelp.setHelp((Control)object, TestJavaPlugin.getID() + ContextIds.BEHAVIOR_NAME_FORM);
				break;
				
			case HELP_FORM_CONTROL:
				WorkbenchHelp.setHelp((Control)object, TestJavaPlugin.getID() + ContextIds.BEHAVIOR_FORM);
				break;
				
			case HELP_SECTION_CONTROL:
				WorkbenchHelp.setHelp((Control)object, TestJavaPlugin.getID() + ContextIds.BEHAVIOR_SECTION_FORM);
				break;
		}
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.BehaviorForm#addDetails(org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection)
	 */
	protected void addDetails(DetailSection detailSection)
	{
		detailSection.add(ILoop.class, new LoopDetailPage()
		{
			protected String getIteractionsLabel()
			{
				return TestJavaPlugin.getString("LBL_NBR_ITERS");
			}
			
			protected String getSynchronousLabel()
			{
				return TestJavaPlugin.getString("BTN_IS_SYNC");
			}

			protected void registerHelp(int flag, Object object)
			{
				switch(flag)
				{
					case HELP_PAGE_CONTROL:
						WorkbenchHelp.setHelp((Control)object, TestJavaPlugin.getID() + ContextIds.LOOP_DETAIL_PAGE);				
						break;

					case HELP_ITERATION_CONTROL:
						WorkbenchHelp.setHelp((Control)object, TestJavaPlugin.getID() + ContextIds.LOOP_DETAIL_TEXT);				
						break;

					case HELP_SYNCHRONOUS_CONTROL:
						WorkbenchHelp.setHelp((Control)object, TestJavaPlugin.getID() + ContextIds.LOOP_DETAIL_SYNCH);				
						break;
				}
			}
		});
		
		detailSection.add(ITestInvocation.class, new TestInvocationDetailPage()
		{
			protected InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite testSuite)
			{
				return TestJavaUtil.createInvokedTestSelectionDialog(testSuite, true);
			}

			protected String getSynchronousLabel()
			{
				return TestJavaPlugin.getString("BTN_IS_SYNC");
			}

			protected String getDeftaultLinkText()
			{
				return TestJavaPlugin.getString("NO_TST_TO_INV");
			}
			
			protected String getDeftaultLinkToolTip()
			{
				return TestJavaPlugin.getString("TIP_INV_TEST");
			}
		});
	}	
}
