/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.java.internal.junit.editor;

import org.eclipse.hyades.test.common.internal.editor.TestSuiteEditorExtension;
import org.eclipse.hyades.test.java.TestJavaPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;
import org.eclipse.hyades.ui.editor.IHyadesEditorPart;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class JUnitEditorExtension 
extends TestSuiteEditorExtension
{
	public static final String EXTENSION_ID = "org.eclipse.hyades.test.java.internal.junit.editor.JUnitEditorExtension";

	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#createPages()
	 */
	public void createPages()
	{
		IHyadesEditorPart hyadesEditorPart = getHyadesEditorPart();
		WidgetFactory widgetFactory = new WidgetFactory();
		
		setTestSuiteForm(new JUnitForm(this, widgetFactory));
		getTestSuiteForm().setTestCasePageIndex(PAGE_TEST_CASES);
		hyadesEditorPart.addPage(getTestSuiteForm().createControl());
		hyadesEditorPart.setPageText(PAGE_OVERVIEW, TestJavaPlugin.getString("W_OVERVIEW"));

		setTestCasesForm(new JUnitTestCasesForm(this, widgetFactory));
		hyadesEditorPart.addPage(getTestCasesForm().createControl());
		hyadesEditorPart.setPageText(PAGE_TEST_CASES, TestJavaPlugin.getString("W_TST_METHS"));
		
		setBehaviorForm(new JUnitBehaviorForm(this, widgetFactory));
		hyadesEditorPart.addPage(getBehaviorForm().createControl());
		hyadesEditorPart.setPageText(PAGE_BEHAVIOR, TestJavaPlugin.getString("W_BEHAVIOR"));
		
		getTestSuiteForm().updateTitle();
	}
}