package org.eclipse.hyades.execution.security;
/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;

import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;


/**
 * @author rduggan
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public final class SecureServer implements Runnable {
	private SSLServerSocket sslsocket;
	private IConnectionHandler connectionHandler;


	private IKeystoreManager loadKeystore(ISecureServerParameters params) 
		 throws java.security.KeyStoreException, 
		        java.security.NoSuchAlgorithmException,
		        java.security.UnrecoverableKeyException,
		        java.security.KeyManagementException,
		        java.security.cert.CertificateException,
		        java.io.IOException
	{
		IKeystoreManager manager=params.getKeystoreManager();
		manager.setProvider(params.getSecurityProvider());
		manager.loadKeystore(params.getKeystoreFileName(), params.getKeystoreFilepassword()); 
		return manager;
	}


	public void init(ISecureServerParameters params) 
		throws java.security.KeyStoreException, 
				java.security.NoSuchAlgorithmException,
				java.security.UnrecoverableKeyException,
				java.security.KeyManagementException,
				java.security.cert.CertificateException,
				java.io.IOException{
		int protocolOffset = 0;
		IKeystoreManager keyManager=null;
		
		/* add the proper security provider */
		Security.addProvider(params.getSecurityProvider());
		
		
		/* Load our keystore */
		keyManager=loadKeystore(params);
		
		/* Find the protocols we can use */ 
		String[] sslProtocols = params.getEnabledProtocols();
		if(sslProtocols==null) {
			sslProtocols=new String[] {"SSL"};
		}
		
		/* Setup our SSLContext */
		SSLContext sslContext=null;
		do {
		
			try {
				sslContext=SSLContext.getInstance(sslProtocols[protocolOffset]/*, params.getSecurityProvider()*/);
				break;
			}
			catch(NoSuchAlgorithmException e) {
				protocolOffset++;
				if(protocolOffset==sslProtocols.length) {
					throw e;		
				}		
			}		
		}while(protocolOffset<sslProtocols.length);
			
		/* Initailize our context with the specified key and trust managers */
		sslContext.init(keyManager.getKeyManagers(), keyManager.getTrustManagers(), null);

		
		/* Create out Secure socket to accept connections */
		sslsocket=(SSLServerSocket)sslContext.getServerSocketFactory().createServerSocket(params.getPort());
		
		/* Configure our socket to recieve only the type of client connections specified */
		sslsocket.setNeedClientAuth(params.clientAuthenticationRequired());
		sslsocket.setWantClientAuth(params.clientAuthenticationRequired());
		
		/* Use the cypher suites specified */
		String[] cyphers=params.getEnabledCipherSuites();
		if(cyphers!=null) {
			sslsocket.setEnabledCipherSuites(params.getEnabledCipherSuites());
		}
		else {
			sslsocket.setEnabledCipherSuites(sslsocket.getEnabledCipherSuites());
		}
		
		/* Enable session creation */
		sslsocket.setEnableSessionCreation(true);
	
		/* Determine who is going to handle incomming connections */
		connectionHandler=params.getConnectionHandler();
	}
	
	public void run() {
		
		while(true) {
			
			try {
				SSLSocket socket=(SSLSocket)sslsocket.accept();	
				
				socket.addHandshakeCompletedListener(new HandshakeCompletedListener() {

					public void handshakeCompleted(HandshakeCompletedEvent event) {
					}
					
				});
				
				//socket.startHandshake();
				
			
				/* The underlying JSSE code returns the SSL socket before all
				 * the SSL handshakes, including client authentication, are
				 * completed.  The handshake carries on, asynchronously, in
				 * the background. If the handshake fails then the socket is
				 * not usable. We synchronize things by calling getSession()
				 * on the SSL socket.  The thread calling getSession() is
				 * forced to wait until the underlying SSL handshake is completed,
				 *  and if the handshake fails then getSession() returns a null.
				 */
			    SSLSession session = socket.getSession();
			    
				if (session==null ||session.getCipherSuite().equals("SSL_NULL_WITH_NULL_NULL")) {
				}
				else if(connectionHandler!=null) {
					connectionHandler.connectionAccepted(socket);
				}
			}
			catch(IOException e) {
				/* TODO Handle this exception with a log message */
				System.out.println(e.getMessage());
			}
		}
	}
}
