/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.navigator;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.HyadesConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.util.ResourceUtil;
import org.eclipse.hyades.ui.util.IDisposable;

/**
 * @author marcelop
 * @since 1.1.0
 */
public class LogContentProvider 
implements ITreeContentProvider, IDisposable
{
	public final static String SD_FILE_EXTENSION = "trcdbxmi";
	
	private TreeViewer treeViewer;
	
	private LogicalFolder logFolder;
	private LogicalFolder sdFolder;
	
	private boolean filesLoaded = false;

	/**
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	public void dispose()
	{
		if (logFolder != null)
			logFolder.dispose();
		if (sdFolder != null)
			sdFolder.dispose();
			
		treeViewer = null;
	}
	
	public ResourceSet getResourceSet()
	{
		return UIPlugin.getDefault().getResourceSet();
	}
	
	public TreeViewer getTreeViewer()
	{
		return treeViewer;
	}
	
	protected void loadFiles()
	{
		String[] extensions = new String[]{SD_FILE_EXTENSION, TraceConstants.PROCESS_EXT};
		Map filesByExtension = ResourceUtil.getFiles(ResourcesPlugin.getWorkspace().getRoot(), extensions, null);

		getSDFolder().getChildren().addAll((List)filesByExtension.get(SD_FILE_EXTENSION));

		for(Iterator i = ((List)filesByExtension.get(TraceConstants.PROCESS_EXT)).iterator(); i.hasNext();)
		{
			EObject[] eObjects = EMFUtil.load(getResourceSet(), (IFile)i.next());
			for (int j = 0, maxj = eObjects.length; j < maxj; j++)
			{
				if(eObjects[j] instanceof TRCProcessProxy)
				{
					for (Iterator k = ((TRCProcessProxy)eObjects[j]).getAgentProxies().iterator(); k.hasNext();)
					{
						TRCAgentProxy agentProxy = (TRCAgentProxy)k.next();
						if(HyadesConstants.LOG_AGENT_TYPE.equals(agentProxy.getType()))
							getLogFolder().getChildren().add(agentProxy);
					}
				}
			}
		}
		
		filesLoaded = true;
	}

	public LogicalFolder getLogFolder()
	{
		if (logFolder == null)
		{
			logFolder = new LogicalFolder(LogUIPlugin.getResourceString("LOG_NAV_LOGFLD"))
			{
				protected List createChildren()
				{
					return new UniqueEList();
				}
			};
		}
		return logFolder;
	}

	public LogicalFolder getSDFolder()
	{
		if (sdFolder == null)
		{
			sdFolder = new LogicalFolder(LogUIPlugin.getResourceString("LOG_NAV_SDFLD"))
			{
				protected List createChildren()
				{
					return new UniqueEList();
				}
			};
		}
		return sdFolder;
	}

	/**
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput)
	{
		if (logFolder != null)
			logFolder.getChildren().clear();
		if (sdFolder != null)
			sdFolder.getChildren().clear();
			
		if(viewer instanceof TreeViewer)
			treeViewer = (TreeViewer)viewer;
	}

	/**
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
	 */
	public Object getParent(Object element)
	{
		if(element instanceof TRCAgentProxy)
			return getLogFolder();
			

		if (element instanceof IFile)
		{
			if(SD_FILE_EXTENSION.equals(((IFile)element).getFileExtension()))
				return getSDFolder();
		}
		
		if(element instanceof LogicalFolder)
			return ((LogicalFolder)element).getParent();

		return null;
	}

	/**
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object inputElement)
	{
		if(inputElement instanceof IWorkspaceRoot)
			return new Object[]{getLogFolder(), getSDFolder()};
			
		return new Object[0];
	}

	/**
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
	 */
	public boolean hasChildren(Object element)
	{
		if(element instanceof LogicalFolder)
		{
			if(!filesLoaded)
				loadFiles();
			return !((LogicalFolder)element).getChildren().isEmpty();
		}
		
		return false;
	}

	/**
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object parentElement)
	{
		if(parentElement instanceof LogicalFolder)
			return ((LogicalFolder)parentElement).getChildren().toArray();
		
		return new Object[0];
	}
}
