/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.internal.ui.PDLabelProvider;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;

/**
 * @author marcelop
 * @since 1.1.0
 */
public class LogLabelProvider 
extends LabelProvider
{
	private PDLabelProvider pdLabelProvider;
	
	public LogLabelProvider()
	{
		pdLabelProvider = new PDLabelProvider();
	}
	
	/**
	 * @see org.eclipse.jface.viewers.LabelProvider#dispose()
	 */
	public void dispose()
	{
		pdLabelProvider.dispose();
		super.dispose();
	}

	
	/**
	 * @see org.eclipse.jface.viewers.ILabelProvider#getImage(java.lang.Object)
	 */
	public Image getImage(Object element)
	{
		if(element instanceof LogicalFolder)
			return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_OBJ_FOLDER).createImage();
		
		if(element instanceof TRCAgentProxy)
			return pdLabelProvider.getImage(element);
		
		if(element instanceof IResource)
		{
			IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)((IResource)element).getAdapter(IWorkbenchAdapter.class);
			if(workbenchAdapter != null)
				return workbenchAdapter.getImageDescriptor(element).createImage();
		}
		
		return null;
	}

	/**
	 * @see org.eclipse.jface.viewers.ILabelProvider#getText(java.lang.Object)
	 */
	public String getText(Object element)
	{
		if(element instanceof LogicalFolder)
			return ((LogicalFolder)element).getName();

		if(element instanceof TRCAgentProxy)
		{
			TRCAgentProxy agentProxy = (TRCAgentProxy)element;
			String file = agentProxy.getProfileFile();
			if(file == null)
				file = agentProxy.getName();
			if(file == null)
				return pdLabelProvider.getText(agentProxy);
				
			if((agentProxy.getProcessProxy() != null) && (agentProxy.getProcessProxy().getNode() != null))
			{
				String node = agentProxy.getProcessProxy().getNode().getName();
				if(node != null)
					return LogUIPlugin.getResourceString("LOG_NAV_LOGLBLFMT", new String[]{node, file}); 
			}
			
			return file;			
		}
		
		if(element instanceof IFile)
			return ((IFile)element).getFullPath().toString();

		if(element instanceof IResource)
		{
			IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)((IResource)element).getAdapter(IWorkbenchAdapter.class);
			if(workbenchAdapter != null)
				return workbenchAdapter.getLabel(element);
		}
		
		return "";
	}
}
