/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.navigator;

import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigator;
import org.eclipse.hyades.ui.internal.provider.ResourceChangeUpdaterProvider;

/**
 * @author marcelop
 * @since 1.1.0
 */
public class LogNavigator extends TreeNavigator
{
	private LogContentProvider contentProvider;
	private ResourceChangeUpdaterProvider resourceChangeUpdaterProvider;
	private LogNavigatorSynchronizer synchronizer;
	
	/**
	 * Constructor for LogNavigator
	 */
	public LogNavigator()
	{
		super();
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.navigator.TreeNavigator#dispose()
	 */
	public void dispose()
	{
		ResourcesPlugin.getWorkspace().removeResourceChangeListener(resourceChangeUpdaterProvider);
		resourceChangeUpdaterProvider.dispose();
		resourceChangeUpdaterProvider = null;

		contentProvider.getResourceSet().eAdapters().remove(synchronizer);
		synchronizer.dispose();
		synchronizer = null;
				
		contentProvider.dispose();
		contentProvider = null;
		
		super.dispose();
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.navigator.INavigator#getPlugin()
	 */
	public AbstractUIPlugin getPlugin()
	{
		return LogUIPlugin.getDefault();
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.navigator.INavigator#isShowingFolders()
	 */
	public boolean isShowingFolders()
	{
		return false;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.navigator.Navigator#createActions()
	 */
	protected void createActions()
	{

	}

	/**
	 * @see org.eclipse.hyades.ui.internal.navigator.Navigator#createViewerInput()
	 */
	protected Object createViewerInput()
	{
		return ResourcesPlugin.getWorkspace().getRoot();
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.navigator.Navigator#editorActivated(org.eclipse.ui.IEditorPart)
	 */
	protected boolean editorActivated(IEditorPart editor)
	{
		return false;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.navigator.Navigator#getStoreSection()
	 */
	public String getStoreSection()
	{
		return null;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.navigator.Navigator#linkToEditor(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected void linkToEditor(IStructuredSelection selection)
	{

	}
	
	public LogContentProvider getContentProvider()
	{
		return contentProvider;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.navigator.TreeNavigator#adjustTreeViewer(org.eclipse.jface.viewers.TreeViewer)
	 */
	protected void adjustTreeViewer(TreeViewer treeViewer)
	{
		contentProvider = new LogContentProvider();
		treeViewer.setContentProvider(contentProvider);
		treeViewer.setLabelProvider(new LogLabelProvider());
		
		resourceChangeUpdaterProvider = new ResourceChangeUpdaterProvider.UIUpdaterProvider();
		ResourcesPlugin.getWorkspace().addResourceChangeListener(resourceChangeUpdaterProvider, IResourceChangeEvent.POST_CHANGE);
		
		synchronizer = new LogNavigatorSynchronizer(this);
		synchronizer.register(resourceChangeUpdaterProvider, contentProvider.getResourceSet());		
	}	
}
