/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.util;


import java.util.*;
import java.util.List;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDLabelProvider;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.HyadesConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;
/**
 * 
 */
public class TraceMergeUI{

	private Button _chkMerge;
	private TreeViewer _viewer;
	private Label _description;
	private List _monitorsList = new ArrayList();
	/**
	 * Constructor for TraceMergeUI.
	 */
	public TraceMergeUI() {
		super();
	}

	public Composite createControl(Composite parent)
	{
		GridLayout layout;
		GridData   data;
		
		Composite result = new Composite(parent, SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 1;
	
		result.setLayout(layout);
		data = GridUtil.createFill();
		data.heightHint = 100;

		result.setLayoutData(data);
		createSpace(result);
		createMergeGroup(result);
		createDescription(result);
		createTreeViewer(result);
		
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			_chkMerge,
			LogUIPlugin.getPluginId()+".tmlo0001");

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			_viewer.getControl(),
			LogUIPlugin.getPluginId()+".tmlo0002");
		
		return result;
	}
	
	private void createMergeGroup(Composite result){
	
		Composite grpMerge = new Composite(result, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		grpMerge.setLayout(layout);
			
		_chkMerge = new Button(grpMerge, SWT.CHECK);
		_chkMerge.setText(LogUIPlugin.getResourceString("STR_MERGE_LBL_"));
		GridData data = new GridData();
		data.horizontalIndent = 15;
		_chkMerge.setLayoutData(data);
	
	}
	
	private void createSpace(Composite parent){
		Label space = new Label(parent, SWT.NONE);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		space.setLayoutData(data);
	}
	
	private void createDescription(Composite parent){
		_description = new Label(parent, SWT.NONE);
		GridData data = new GridData();
		data.horizontalIndent = 15;
		_description.setLayoutData(data);
	
		_description.setText(LogUIPlugin.getResourceString("STR_MERGETREE_DESC"));
		//_description.setVisible(false);
	}
	private void createTreeViewer(Composite result){
					
		_viewer = new TreeViewer(result);
		_viewer.setContentProvider(new TraceMergeUIContentProvider());
		_viewer.setLabelProvider(new PDLabelProvider());
		_viewer.setInput(ResourcesPlugin.getWorkspace().getRoot());
	
		GridData tree = GridUtil.createFill();
		tree.widthHint = 200;
		tree.horizontalIndent = 15;
	    _viewer.getTree().setLayoutData(tree);
		_viewer.getTree().setEnabled(false);
	
	}
	
	public Tree getTree(){
		return _viewer.getTree();
	}
	
	public Button getMergeButton(){
		return _chkMerge;
	}
		
	public Label getDescription(){
		return _description;
	}
	
	public void selectMergedAgent(TRCAgentProxy mergedAgent){
		_viewer.setExpandedState(mergedAgent.getProcessProxy(), true);
		_viewer.setSelection(new StructuredSelection(mergedAgent));
	}
	
	class TraceMergeUIContentProvider implements IStructuredContentProvider, ITreeContentProvider{
	 	
	 	public TraceMergeUIContentProvider(){ 	
	 	}
	 	
		public Object[] getElements(Object inputElement) {

			List list = new ArrayList();
			if(inputElement instanceof IWorkspaceRoot){
				getProcessesFromMemory(list, inputElement);	
				getProcessesFromWorkspace(list, inputElement);
			}
			else if(inputElement instanceof TRCProcessProxy){
				list.addAll(getLogAgents((TRCProcessProxy)inputElement));
			}
			return list.toArray();
		}

		private void getProcessesFromMemory(List list, Object inputElement){
			EList resources = UIPlugin.getDefault().getResourceSet().getResources();
			int size = resources.size();
			for(int i=0; i<size;i++){
				Resource res = (Resource)resources.get(i);
				EList ext = res.getContents();
				Iterator iter = ext.iterator();
				while (iter.hasNext())
				{
					Object obj = iter.next();
					if (obj instanceof TRCMonitor){
						_monitorsList.add(obj);
						list.addAll(getProcesses((TRCMonitor)obj));
					}					
				}
			}
			
		}
		
		private void getProcessesFromWorkspace(List list, Object inputElement){
			IProject[] projects = ((IWorkspaceRoot)inputElement).getProjects();
			for(int idx=0; idx< projects.length; idx++){
				List resources = getResources(projects[idx]);
				for(int j = 0; j<resources.size(); j++){
					IResource resource = (IResource)resources.get(j);
					if(resource!=null){
						List monitors = getMonitors(resource);
						int monitors_size = monitors.size();
						for(int k=0; k < monitors_size; k++){ 	
							TRCMonitor monitor = (TRCMonitor)monitors.get(k);
							if(monitor!=null && !_monitorsList.contains(monitor)){
								 list.addAll(getProcesses(monitor));
							}
							else{
								continue;
							}
						}							
					}
					else{
						continue;
					}
				}
			}
		
		}
		
		private List getResources(IContainer project){
			List resources = new ArrayList();
			IResource[] members;
			try {
				members = project.members();
				for(int idx=0; idx<members.length; idx++)
				{
					IResource member = members[idx];
					if(member== null || !member.exists())
					  continue;
				  
					if(member instanceof IFile && ((IFile)member).getFileExtension() != null &&
					((IFile)member).getFileExtension().equals(TraceConstants.MONITOR_EXT)){
						resources.add(member);
					}
	
				}
			} catch (CoreException e) {
				e.printStackTrace();
			}
	
			return resources;
			
		}
		
		private List getMonitors(IResource resource){

			List monList = new ArrayList(); 
			ResourceSet resourceSet = UIPlugin.getDefault().getResourceSet();					
			Resource res = null;
			try
			{
				String monPath = resource.getFullPath().toString();	
				String name = monPath;
	
				res = resourceSet.getResource(URI.createURI("platform:/resource"+ name), true);
			
				EList ext = res.getContents();
				Iterator i = ext.iterator();
				while (i.hasNext())
				{
					Object obj = i.next();
					if (obj instanceof TRCMonitor){
						monList.add(obj);
					}
				} 
	   
			}
			catch (Exception e) {
			   e.printStackTrace();
			}
			
			return monList;

		}
		
		private List getProcesses(TRCMonitor monitor){
			
			EList nodes = monitor.getNodes();
			List processes = new ArrayList();
			int nodes_size = nodes.size();
			for(int i=0; i < nodes_size; i++){
				EList list = ((TRCNode)nodes.get(i)).getProcessProxies();
				processes.addAll(list);
			}
			return processes;
		}
		
		private List getLogAgents(TRCProcessProxy process){
			
			EList agents = process.getAgentProxies();
			int agents_size = agents.size();
			List log_agents = new ArrayList();
			for(int i=0; i < agents_size; i++){
				TRCAgentProxy agent = (TRCAgentProxy)agents.get(i);
				if(agent.getType().equals(HyadesConstants.LOG_AGENT_TYPE)){
					log_agents.add(agent);
				}
			}
			return log_agents;
			
		}
		
		public void dispose() {

		}

		public void inputChanged(
			Viewer viewer,
			Object oldInput,
			Object newInput) {

		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
		 */
		public Object[] getChildren(Object parentElement) {

			return getElements(parentElement);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
		 */
		public Object getParent(Object element) {

			return null;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
		 */
		public boolean hasChildren(Object element) {

			if(element instanceof TRCAgentProxy){
				return false;
			}
			return true;
		}

	}
	
}
