/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * Created on Jul 29, 2003
 *
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/**
 * @author apnan
 *
 */
public class ImportLogWizardPage extends WizardPage implements SelectionListener{

	private LogParserUI _parserUI;
	//private LogFileDetailsUI _detailsUI;
	private Table logsTable;
	private TableViewer fTableViewer;
	private List logElements = new ArrayList();
	private Button addBtn, removeBtn, editBtn;
	private LogFileElement selection;
	private LogFileDetailsUI dialog;
	private Label type_label;
	
	public ImportLogWizardPage() {
		
		super("ImportLogWizardPage");		
		setTitle(LogUIPlugin.getResourceString("LOG_PARSER_PAGE_TITLE"));
		setDescription(LogUIPlugin.getResourceString("LOG_PARSER_PAGE_DESC"));
	}
	
	public void createControl(Composite parent) {
	
		Composite result = new Composite(parent, SWT.NONE);
		result.setLayoutData(GridUtil.createFill());
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		result.setLayout(layout);
			
		Label logs_desc = new Label(result, SWT.NONE);
		GridData data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 2;		
		logs_desc.setLayoutData(data);
		logs_desc.setText(LogUIPlugin.getResourceString("STR_LOG_PDESC"));

		createTable(result);
		createButtons(result);						

		type_label = new Label(result, SWT.NONE);
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 2;		
		type_label.setLayoutData(data);

		setControl(result);
		
		/*org.eclipse.ui.help.WorkbenchHelp.setHelp(
			parent,
			LogUIPlugin.getPluginId() + ".pp0000");*/
		
		setPageComplete(false);
	}
	
	private void createTable(Composite parent){
		
		logsTable = new Table(parent, SWT.BORDER|SWT.H_SCROLL|SWT.V_SCROLL|SWT.FULL_SELECTION|SWT.SINGLE);
		GridData tblData = GridUtil.createFill();
		tblData.heightHint = 75;
		tblData.widthHint = 330;	
		logsTable.setLayoutData(tblData);

		TableColumn column0= new TableColumn(logsTable, SWT.NONE); 

		TableColumn column1= new TableColumn(logsTable, SWT.NONE);		
		column1.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_HOST")); 

		TableColumn column2= new TableColumn(logsTable, SWT.NONE);
		column2.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_PATH"));
		
		ColumnLayoutData c0Layout = new ColumnWeightData(10, false);		
		// path column
		ColumnLayoutData c1Layout = new ColumnWeightData(50, true);

		// host column
		ColumnLayoutData c2Layout = new ColumnWeightData(125, true);

		// set columns in Table layout
		TableLayout tblLayout = new TableLayout();
		tblLayout.addColumnData(c0Layout);
		tblLayout.addColumnData(c1Layout);
		tblLayout.addColumnData(c2Layout);
		logsTable.setLayout(tblLayout);
		logsTable.setHeaderVisible(true);
		logsTable.setLinesVisible(true);
		fTableViewer= new TableViewer(logsTable);		

		fTableViewer.setLabelProvider(new TableLabelProvider());
		
		fTableViewer.setContentProvider(new TableContentProvider());
		fTableViewer.setInput(logElements);
		
		logsTable.addSelectionListener(this);
	
	}
	
	private void createButtons(Composite parent){
		
		Composite buttonGrp = new Composite(parent, SWT.NONE);	
		GridData btnData = GridUtil.createFill();
		GridLayout btnLayout = new GridLayout();
		btnLayout.numColumns = 1;		
		btnData.verticalAlignment = GridData.BEGINNING;
		buttonGrp.setLayout(btnLayout);
		buttonGrp.setLayoutData(btnData);
				
		addBtn = new Button(buttonGrp, SWT.PUSH);
		addBtn.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_ADD"));
		btnData = GridUtil.createHorizontalFill();
		btnData.widthHint = 90;
		btnData.horizontalAlignment = GridData.CENTER;
		addBtn.setLayoutData(btnData);		
		
		editBtn = new Button(buttonGrp, SWT.PUSH);
		editBtn.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_EDIT"));
		btnData = GridUtil.createHorizontalFill();
		btnData.widthHint = 90;
		btnData.horizontalAlignment = GridData.CENTER;
		editBtn.setLayoutData(btnData);
			
		removeBtn = new Button(buttonGrp, SWT.PUSH);
		removeBtn.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_REMOVE"));
		btnData = GridUtil.createHorizontalFill();
		btnData.widthHint = 90;
		btnData.horizontalAlignment = GridData.CENTER;
		removeBtn.setLayoutData(btnData);
		
		addBtn.addSelectionListener(this);
		editBtn.addSelectionListener(this);
		removeBtn.addSelectionListener(this);
		
		updateButtons();
	}
	
	private void updateButtons(){
		if(logElements.size()==0){
			editBtn.setEnabled(false);
			removeBtn.setEnabled(false);
			return;
		}

		editBtn.setEnabled(logsTable.getSelectionCount()>0);
		removeBtn.setEnabled(logsTable.getSelectionCount()>0);			
	}
	
	public void refresh(){
		fTableViewer.refresh();
	}
	
	public boolean finish() {
		return true;
	}

	public void dispose()
	{
		super.dispose();
		//_parserUI.dispose();
	}
	
	public void addElement(LogFileElement element){
		logElements.add(element);
	}
	
	public LogFileElement getSelectedElement(){
		return selection;
	}
	
	public List getLogFileElements(){
		return logElements;
	}
		
	public boolean isPageComplete(){
		
		List elem = getLogFileElements();
		boolean complete = elem.size()>0 ? true:false;
		for (Iterator iter = elem.iterator(); iter.hasNext();) {
			LogFileElement element = (LogFileElement) iter.next();
			// need to update the valid flag for all the elements in order to display the corresponding icon in the elements table
			element.setValid(isLogElementValid(element));
			complete = complete && element.isValid();
		}
		return complete;			
	}
	
	public void initializePage(LogFileElement element){
		if(dialog!=null){
			dialog.initialize(element);
		}

	}
				
	public LogFileDetailsUI getDialog(){
		
		if(dialog==null){
			dialog = new LogFileDetailsUI(getShell(), this);
		}
		return dialog;

	}

	class TableContentProvider implements IStructuredContentProvider{
	
			/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
		 */
		public Object[] getElements(Object inputElement) {			
			return logElements.toArray();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
		 */
		public void dispose() {

		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
		 */
		public void inputChanged(
			Viewer viewer,
			Object oldInput,
			Object newInput) {

		}

	}
	
	class TableLabelProvider extends LabelProvider implements ITableLabelProvider{

		private Hashtable images =  new Hashtable();
			/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object, int)
		 */
		public Image getColumnImage(Object element, int columnIndex) {
			
			if(columnIndex==0){

				return getImageHelper(((LogFileElement)element).getParser());

			}
			return null; 
		}

		private Image getImageHelper(LogParserItem parser){
			Image img = (Image)images.get(parser.getDescription());
			if(img==null){
				img = parser.getImageDescriptor().createImage();
				images.put(parser.getDescription(), img);
			}
			return img;
			
		}
		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object, int)
		 */
		public String getColumnText(Object element, int columnIndex) {

			if(columnIndex==1){
				return ((LogFileElement)element).getHost();				
			}
			if(columnIndex==2){
				return (String)((LogFileElement)element).getValues().get(0);				
			}
			
			return "";
		}
		
		
		/*
		 * @see IBaseLabelProvider#dispose()
		 */
		public void dispose() {
			for (Enumeration enum = images.elements(); enum.hasMoreElements();) {
				Image image = (Image) enum.nextElement();
				if (image.isDisposed() == false)
					image.dispose();
			}
			images.clear();
			
			super.dispose();
		}
		
		

}
	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) {

	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) {
		
		if(e.widget==addBtn){
			selection = new LogFileElement();
			addElement(selection);
			fTableViewer.setSelection(new StructuredSelection(selection));
			getDialog().setLogFileElement(selection);			
			getDialog().setWindowTitle(LogUIPlugin.getResourceString("STR_ADD_LOG_FILE"));
			
			if(getDialog().open()==Window.OK){
				setPageComplete(isPageComplete());				
				refresh();				
			}else{
				logElements.remove(selection);
			}
			dialog = null;			
		}
		else if (e.widget==editBtn){
			getDialog().setLogFileElement(selection);
			getDialog().setWindowTitle(LogUIPlugin.getResourceString("STR_EDIT_LOG_FILE"));		
			if(getDialog().open()==Window.OK){
				setPageComplete(isPageComplete());
				refresh();
			}
			dialog = null;
		}
		else if (e.widget==removeBtn){
			logElements.remove(selection);
			refresh();
			setPageComplete(isPageComplete());
		}else if(e.widget==logsTable){
			int index = logsTable.getSelectionIndex();
			selection = (LogFileElement)logElements.get(index);
			type_label.setText(selection.getParser().getDescription());
		}
		updateButtons();
	}

	
	
	public boolean isLogElementValid(LogFileElement elem){
		
		boolean valDest = (elem.getHost()!=null && elem.getHost().length()>0)&&
		(elem.getMonitor()!=null && elem.getMonitor().length()>0)&&
		(elem.getProject()!=null && elem.getProject().length()>0);
		boolean valValues = true;
		List values = elem.getValues();
		for (Iterator iter = values.iterator(); iter.hasNext();) {
			String element = (String) iter.next();
			if(element.length()==0){
				valValues = false;
				break;
			}
		}
		return valValues && valDest;
		
	}
	
	public void initLocation(){
		dialog.initLocation();
	}

}