/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * Created on Jul 30, 2003
 *
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.io.File;
import java.util.*;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.hyades.logging.parsers.IWidgetListener;
import org.eclipse.hyades.sdb.internal.util.TString;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;

/**
 * @author apnan
 *
 */
 
public class LogLocationUI  implements Listener, ModifyListener{


	private String _logParserId;
	//private boolean isLocal = false;
	private String lastWasHome = "";
	private String prefix = "ImportLogFile.";
	private String host = "";
	//private boolean bTextHasChanged = false;
	private ImportLogWizardPage page;
	private LogFileDetailsUI details;
	private ParserPropertiesComposite[] composites;

	private Shell shell;
	
	/**
	 * Keeps track of the widgets added to the Location wizard page
	 * Key = Widget ; Value = Listener
	 */
	private Hashtable _widgets = new Hashtable();
	
	/**
	 * Constants used to identify widget types 
	 */
	private static final short COMBO_BOX = 0, CHECK_BOX =1, RADIO = 2, TEXT_AREA = 3, TEXT_FIELD = 4;
    
	/**
	 * Keeps tracks of the listeners that _widgets have been sent to.
	 * Stores the hashCode() of the listener object.
	 */
	private Vector _listenersServed = new Vector();

	
	public LogLocationUI(ImportLogWizardPage page, LogFileDetailsUI details){
		this.page = page;
		this.details = details;
	}
	
	public Composite createControl(Composite parent) {
		
		composites = new ParserPropertiesComposite[details.getParserCount()];
			
		LogParserItem item = details.getSelectedParser();
		
		return createControl(parent, item);
		
	}

	protected Composite createControl(Composite parent, LogParserItem parser){
        
		ParserPropertiesComposite composite = new ParserPropertiesComposite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		
		/* Reinitialize the widgets and the listeners served lists */
		_widgets = new Hashtable();
		_listenersServed = new Vector();
		
		layout.numColumns = 2;
        
		composite.setLayout(layout);
		composite.setLayoutData(GridUtil.createFill());

		ArrayList fields = parser.getFields();
        
		prefix = details.getHostName() + "." +  details.getSelectedParser().getDescription() +".";
        
		for (int idx = 0; idx <fields.size(); idx++) {
        	
			ParserField field = (ParserField) fields.get(idx);            
			if(field!=null){                        
				createWidget(composite, field);
			}
		}
		
		composites[details.indexOf(parser)] =  composite;
		enableButtons(composite);
		return composite;
	
	}
	protected void createVerticalSpace(Composite comp, int colSpan){
		Label label = new Label(comp, SWT.NONE);
		GridData gd = new GridData();
		gd.horizontalSpan = colSpan;
		label.setLayoutData(gd);
	}
	 
	public void createWidget(ParserPropertiesComposite composite, ParserField field){
		IImportWizardWidget widget = null;
		
		String trim = field.getUiType().trim();
		short type = TEXT_FIELD;
    	
		/* Instantiate the appropriate object associated with the widget */
		if (trim.equals("combobox"))
		{
			widget = new ImportWizardComboBox(field);
			type = COMBO_BOX;
		} 
		else if (trim.equals("checkbox"))
		{	
			widget = new ImportWizardCheckBox(field);
			type = CHECK_BOX;
		}		
		else if (trim.equals("radio"))
		{	
			widget = new ImportWizardRadioButton(field);
			type = RADIO; 
		}
		else if (trim.equals("text_area"))
		{	
			widget = new ImportWizardTextArea(field);
			type = TEXT_AREA;
		}
		else{
			widget = new ImportWizardTextField(composite.getFiltersTable(), field);
		}
		
		/* Create and set the listener for the widget */
		widget.createControl(composite, prefix);
		String listenerString = widget.getField().getListener(); 

		/* Store the widget and add the listener (currently only selection events
		   are handled) */
			
		if (type == COMBO_BOX)
		{
			_widgets.put(((ImportWizardComboBox)widget).getComboBox(), ((ImportWizardComboBox)widget).getField().getListener());
			if (listenerString != null && listenerString.length() > 0)
				((ImportWizardComboBox)widget).getComboBox().addListener(SWT.Selection,this);
		}
		else if (type == CHECK_BOX)
		{
			_widgets.put(((ImportWizardCheckBox)widget).getCheckBox(), ((ImportWizardCheckBox)widget).getField().getListenerInstance());
			if (listenerString != null && listenerString.length() > 0)
				((ImportWizardCheckBox)widget).getCheckBox().addListener(SWT.Selection,this);
		}
		else if (type == RADIO)
		{
			Iterator buttons = ((ImportWizardRadioButton)widget).getButtonList().iterator();
			Button currentButton;
			while (buttons.hasNext()) {
				currentButton = (Button)buttons.next();
				_widgets.put(currentButton, ((ImportWizardCheckBox)widget).getField().getListener());
				if (listenerString != null && listenerString.length() > 0)
					currentButton.addListener(SWT.Selection,this);
			}
		}
		else if (type == TEXT_AREA)
		{
			_widgets.put(((ImportWizardTextArea)widget).getText(), ((ImportWizardCheckBox)widget).getField().getListener());
			if (listenerString != null && listenerString.length() > 0)
				((ImportWizardTextArea)widget).getText().addListener(SWT.Selection,this);
		}
		else
		{
			_widgets.put(((ImportWizardTextField)widget).getText(), ((ImportWizardTextField)widget).getField().getListener());
			if (listenerString != null && listenerString.length() > 0)
				((ImportWizardTextField)widget).getText().addListener(SWT.Selection,this);
		}


		if (widget instanceof ImportWizardTextField)	{
			ImportWizardTextField textField = (ImportWizardTextField)widget;
			textField.getText().addModifyListener(this);
			composite.getButtonList().add(((ImportWizardTextField)widget).getBtn());
			composite.getFieldList().put(field.getId(), field);   		
		}
		
		composite.getControlLookup().put(field.getId(), widget);
		composite.getFieldIDs().add(field.getId());
	}

	public void initialize(Composite composite, LogFileElement elem) {
		prefix = details.getHostName() + "." +  details.getSelectedParser().getDescription() +".";

		// Initialize text fields with previous values from the preference store, if any exists.
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
            
		String previousValue = "";
		ParserField field = null;
		
		java.util.List values = elem.getValues();
		Map input = ((ParserPropertiesComposite)composite).getControlLookup();
		java.util.List fieldIDs = ((ParserPropertiesComposite)composite).getFieldIDs();

		Map fieldList = ((ParserPropertiesComposite)composite).getFieldList();
		
		IImportWizardWidget widget = null;

		int i=0;

		for (Iterator iter = fieldIDs.iterator(); iter.hasNext();) {
			String id = (String)iter.next();
			widget  = (IImportWizardWidget)input.get(id);
							
			if(i<values.size()){
				if(widget instanceof ImportWizardTextField){
					field = (ParserField)fieldList.get(id);
					previousValue = store.getString(prefix + field.getId());
					if(previousValue != null && !previousValue.equals("")){
						widget.setValue(previousValue);
					}else if(values.get(i)!=null && values.get(i).toString().length()>0){
						widget.setValue((String)values.get(i));
					}else{ 
						widget.setValue(field.getDefaultValue());					
					}									
				}
			}else if(widget instanceof ImportWizardTextField){
				field = (ParserField)fieldList.get(id);				
				previousValue = store.getString(prefix + field.getId());
				if (previousValue != null && !previousValue.equals(""))
					widget.setValue(previousValue);
				else
					widget.setValue(field.getDefaultValue());			
			}
			++i;
		}
	}

	public Hashtable getUserInput(LogParserItem item) {
		ParserPropertiesComposite composite = composites[details.indexOf(item)]; 	
		
		Hashtable table = new Hashtable();
		Iterator iter =  composite.getControlLookup().keySet().iterator();		
		while (iter.hasNext()){		
			String id = (String)iter.next();
			IImportWizardWidget widget = (IImportWizardWidget)composite.getControlLookup().get(id);
			table.put(id, widget.getValue());
		}

		return table;
	}
        
    public Composite getCompositeFor(LogParserItem parser){
		int index = details.indexOf(parser);
		if(index>-1){    	
			return composites[index];
		}
		return null;
    }
    
	/**
	 * 
	 */
	public boolean finish() {
		
		
		ParserField field = null;
		Text text = null;
		LogFileElement logElem = page.getSelectedElement();		
		Hashtable input = getUserInput(logElem.getParser());
		prefix = details.getHostName() + "." +  details.getSelectedParser().getDescription() +".";

//		Update current selected log element		
		updateElement(logElem, input);

//		Save the current values in the preference store.
		Composite selected = getCompositeFor(details.getSelectedParser());
		
		ParserPropertiesComposite composite = (ParserPropertiesComposite)selected;
		Map fields = composite.getFieldList();
		Set keys = fields.keySet();
		for (Iterator iter = keys.iterator(); iter.hasNext();){
		
			field = (ParserField)fields.get(iter.next());
			IImportWizardWidget widget = (IImportWizardWidget)composite.getControlLookup().get(field.getId());

			if(field.useBrowse()    
			&& details.isLocalHost()){
				if(!(new File(widget.getValue()).exists())){
					String message = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_NO_FILE_EXISTS");
					message = TString.change(message, "%1", widget.getValue());
					MessageDialog.openError(page.getShell(), LogUIPlugin.getResourceString("LOGGING_MESSAGE"), message);
					return false;
				}
			}

			if (widget.isValid()){						
				IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
				store.setValue(prefix + field.getId(), widget.getValue());
			}else{
				return false;
			}
		}
		
		return true;
	}

	public void updateElement(LogFileElement logElem, Map input){
		java.util.List fieldIDs = ((ParserPropertiesComposite)getCompositeFor(logElem.getParser())).getFieldIDs();
		java.util.List values = logElem.getValues();
		values.clear();

		for (Iterator iter = fieldIDs.iterator(); iter.hasNext();) {
			values.add(input.get(iter.next()));
		}
	
	}
	
	public void modifyText(ModifyEvent e) {
	
		details.setOKButtonEnabled(((Text)e.widget).getText().length()!=0);
	}


	/**
	 * An event listener for the widgets created.
	 * The user has the option in specifying a listener for each of the parser fields
	 * that is created.  Currently only selected events are handled.  The handler
	 * delegates back to a handler specified in the manifest file of the parser.
	 * 
	 * In future, this method can be implemented to handle all events instead of 
	 * just selections
	 * 
	 * @param event - the event that needs to be handled 
	 */
	public void handleEvent(Event event) {
    	  	
		/* Retrieve the associated widget */
		if (_widgets.containsKey(event.widget))
		{
			IWidgetListener listener = (IWidgetListener)_widgets.get(event.widget);
						
			String value = String.valueOf(listener.hashCode());
			if (!_listenersServed.contains(value))
			{
				_listenersServed.add(value);
				details.updateListenersServed(_listenersServed);
				listener.storeWidgets(_widgets);
			}
			listener.takeAction(event);
		}
	}
	
	public boolean isPageComplete() {

		Composite selected = getCompositeFor(details.getSelectedParser());	
		Iterator iter = ((ParserPropertiesComposite)selected).getControlLookup().values().iterator();
		while (iter.hasNext()){
			IImportWizardWidget widget = (IImportWizardWidget)iter.next();
			if (!(widget.isValid())) return false;
		}
		return true;

	}

	public void enableButtons(Composite composite) {
		boolean isLocalHost = details.isLocalHost();
		java.util.List buttons = ((ParserPropertiesComposite)composite).getButtonList();
		for (int idx = 0; idx <buttons.size(); idx++) {
			Button btn = (Button) buttons.get(idx);
			btn.setEnabled(isLocalHost);
		}			
	}
	
	/**
	 * Sets the widgets of this page
	 * 
	 * @param widgets - The widgets of the Location wizard page
	 */
	public void setWidgets (Hashtable widgets)
	{
		_widgets = widgets;
	}
	
	
	/**
	 * Retunrs the widgets of this page
	 *
	 * @return The widgets of 'Location' wizard page 
	 */
	public Hashtable getWidgets ()
	{
		return _widgets;
	}
	
	
	/**
	 * Sets the listeners that widgets of this page have been sent to.
	 * 
	 * @param listenersServed - The listeners that have received the widgets of the Location wizard page 
	 */
	public void setListenersServed(Vector listenersServed)
	{
		_listenersServed = listenersServed;
	}
	
	
	/**
	 * Return the listeners that widgets of this page have been sent to.
	 * 
	 * @return The listeners that the widgets of this page have been sent to
	 */
	public Vector getListenersServed()
	{
		return _listenersServed;
	}
	
	class ParserPropertiesComposite extends Composite{
		
		private Hashtable _filtersTable = new Hashtable();
		private Map controlLookup = new HashMap();

		private Map _fieldList = new Hashtable();
		private java.util.List _buttonList = new ArrayList();
		private java.util.List ids = new ArrayList(); 

		public ParserPropertiesComposite (Composite parent, int style) {
			super (parent, style);	
		}

		/**
		 * @return ArrayList of buttons in the current composite
		 */
		public java.util.List getButtonList() {
			return _buttonList;
		}

		/**
		 * @return ArrayList of text fields in the current composite
		 */
		public Map getFieldList() {
			return _fieldList;
		}
		
		public java.util.List getFieldIDs(){
			return ids;
		}

		/**
		 * @return Hashtable of filters in the current composite
		 */
		public Hashtable getFiltersTable() {
			return _filtersTable;
		}

		/**
		 * @return Hashtable
		 */
		public Map getControlLookup() {
			return controlLookup;
		}
	}
}
